/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2ObjectHashMap<K, V>
implements Map<K, V>,
Serializable {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private Object[] entries;
    private KeySet keySet;
    private Values values;
    private EntrySet entrySet;

    public Object2ObjectHashMap() {
        this(8, 0.55f);
    }

    public Object2ObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, true);
    }

    public Object2ObjectHashMap(int initialCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        return this.unmapNullValue(this.getMapped(key));
    }

    private V getMapped(Object key) {
        Objects.requireNonNull(key);
        Object[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key.hashCode(), mask);
        Object value = null;
        while (entries[index + 1] != null) {
            if (entries[index] == key || entries[index].equals(key)) {
                value = entries[index + 1];
                break;
            }
            index = Object2ObjectHashMap.next(index, mask);
        }
        return (V)value;
    }

    @Override
    public V put(Object key, Object value) {
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        Object[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key.hashCode(), mask);
        Object oldValue = null;
        while (entries[index + 1] != null) {
            if (entries[index] == key || entries[index].equals(key)) {
                oldValue = entries[index + 1];
                break;
            }
            index = Object2ObjectHashMap.next(index, mask);
        }
        if (oldValue == null) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = val;
        this.increaseCapacity();
        return this.unmapNullValue(oldValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        Object[] oldEntries = this.entries;
        int length = this.entries.length;
        this.capacity(newCapacity);
        Object[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            Object value = oldEntries[keyIndex + 1];
            if (value == null) continue;
            Object key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key.hashCode(), mask);
            while (newEntries[index + 1] != null) {
                index = Object2ObjectHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Object val = this.mapNullValue(value);
        boolean found = false;
        if (val != null) {
            Object[] entries = this.entries;
            int length = entries.length;
            for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
                if (val != entries[valueIndex] && !val.equals(entries[valueIndex])) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, null);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        Object[] entries = this.entries;
        int length = entries.length;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (entries[keyIndex + 1] == null) continue;
            consumer.accept(entries[keyIndex], this.unmapNullValue(entries[keyIndex + 1]));
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMapped(key) != null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Values values() {
        if (null == this.values) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V remove(Object key) {
        Object[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key.hashCode(), mask);
        Object oldValue = null;
        while (entries[keyIndex + 1] != null) {
            if (entries[keyIndex] == key || entries[keyIndex].equals(key)) {
                oldValue = entries[keyIndex + 1];
                entries[keyIndex] = null;
                entries[keyIndex + 1] = null;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Object2ObjectHashMap.next(keyIndex, mask);
        }
        return this.unmapNullValue(oldValue);
    }

    private void compactChain(int deleteKeyIndex) {
        Object[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (entries[(keyIndex = Object2ObjectHashMap.next(keyIndex, mask)) + 1] != null) {
            int hash = Hashing.evenHash(entries[keyIndex].hashCode(), mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = entries[keyIndex];
            entries[deleteKeyIndex + 1] = entries[keyIndex + 1];
            entries[keyIndex] = null;
            entries[keyIndex + 1] = null;
            deleteKeyIndex = keyIndex;
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    protected Object mapNullValue(Object value) {
        return value;
    }

    protected V unmapNullValue(Object value) {
        return (V)value;
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new Object[entriesLength];
        Arrays.fill(this.entries, null);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        private final EntryIterator entryIterator;

        private EntrySet() {
            this.entryIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Object2ObjectHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Object2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = (Map.Entry)o;
            Object value = Object2ObjectHashMap.this.getMapped(entry.getKey());
            return value != null && value.equals(Object2ObjectHashMap.this.mapNullValue(entry.getValue()));
        }
    }

    public final class Values
    extends AbstractCollection<V> {
        private final ValueIterator valueIterator;

        public Values() {
            this.valueIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2ObjectHashMap.this.containsValue(o);
        }
    }

    public final class KeySet
    extends AbstractSet<K>
    implements Serializable {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Object2ObjectHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Object2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return Object2ObjectHashMap.this.containsKey(o);
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        @Override
        public K getKey() {
            return Object2ObjectHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public V getValue() {
            return Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[this.keyPosition() + 1]);
        }

        @Override
        public V setValue(V value) {
            Object val = Object2ObjectHashMap.this.mapNullValue(value);
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (null == val) {
                throw new IllegalArgumentException();
            }
            int keyPosition = this.keyPosition();
            Object prevValue = Object2ObjectHashMap.this.entries[keyPosition + 1];
            ((Object2ObjectHashMap)Object2ObjectHashMap.this).entries[keyPosition + 1] = val;
            return Object2ObjectHashMap.this.unmapNullValue(prevValue);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.findNext();
            if (Object2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, V> allocateDuplicateEntry() {
            final Object k = this.getKey();
            final Object v = this.getValue();
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return k;
                }

                @Override
                public V getValue() {
                    return v;
                }

                @Override
                public V setValue(V value) {
                    return Object2ObjectHashMap.this.put(k, value);
                }

                @Override
                public int hashCode() {
                    Object v2 = this.getValue();
                    return this.getKey().hashCode() ^ (v2 != null ? v2.hashCode() : 0);
                }

                @Override
                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    return e.getKey() != null && e.getKey().equals(k) && (e.getValue() == null && v == null || e.getValue().equals(v));
                }

                public String toString() {
                    return k + "=" + v;
                }
            };
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[this.keyPosition() + 1]);
        }
    }

    final class KeyIterator
    extends AbstractIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            this.findNext();
            return Object2ObjectHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator
    implements Serializable {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Object2ObjectHashMap.this.size;
            Object[] entries = Object2ObjectHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (entries[capacity - 1] != null) {
                for (keyIndex = 0; keyIndex < capacity && entries[keyIndex + 1] != null; keyIndex += 2) {
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        final int keyPosition() {
            return this.positionCounter & Object2ObjectHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] entries = Object2ObjectHashMap.this.entries;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == null) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Object2ObjectHashMap)Object2ObjectHashMap.this).entries[position] = null;
            ((Object2ObjectHashMap)Object2ObjectHashMap.this).entries[position + 1] = null;
            --Object2ObjectHashMap.this.size;
            Object2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

