/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.slf4jtest;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import uk.org.lidalia.lang.Exceptions;

class OverridableProperties {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final String propertySourceName;
    private final Properties properties;
    private static final Function<InputStream, Properties> loadProperties = new Function<InputStream, Properties>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties apply(InputStream propertyResource) {
            boolean throwing = false;
            try {
                Properties loadedProperties = new Properties();
                loadedProperties.load(propertyResource);
                Properties properties = loadedProperties;
                return properties;
            }
            catch (IOException ioException) {
                throwing = true;
                Properties properties = (Properties)Exceptions.throwUnchecked((Throwable)ioException, null);
                return properties;
            }
            finally {
                block11: {
                    try {
                        propertyResource.close();
                    }
                    catch (IOException e) {
                        if (throwing) break block11;
                        Exceptions.throwUnchecked((Throwable)e);
                    }
                }
            }
        }
    };

    OverridableProperties(String propertySourceName) throws IOException {
        this.propertySourceName = propertySourceName;
        this.properties = this.getProperties();
    }

    private Properties getProperties() throws IOException {
        Optional resourceAsStream = Optional.fromNullable((Object)Thread.currentThread().getContextClassLoader().getResourceAsStream(this.propertySourceName + ".properties"));
        return (Properties)resourceAsStream.transform(loadProperties).or((Object)EMPTY_PROPERTIES);
    }

    String getProperty(String propertyKey, String defaultValue) {
        String propertyFileProperty = this.properties.getProperty(propertyKey, defaultValue);
        return System.getProperty(this.propertySourceName + "." + propertyKey, propertyFileProperty);
    }
}

