/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.rsf.evolverimpl;

import uk.org.ponder.beanutil.BeanGetter;
import uk.org.ponder.rsf.components.UIBasicListMember;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UIComponent;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIInitBlock;
import uk.org.ponder.rsf.components.UIInputMany;
import uk.org.ponder.rsf.components.UIJointContainer;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.evolvers.BoundedDynamicListInputEvolver;
import uk.org.ponder.rsf.uitype.UITypes;

public class StandardDynamicListInputEvolver
implements BoundedDynamicListInputEvolver {
    public static final String COMPONENT_ID = "dynamic-list-input:";
    public static final String CORE_ID = "dynamic-list-input-core:";
    private BeanGetter rbg;
    private UIBoundString removelabel;
    private UIBoundString addlabel;
    private int maxlength = 1000;
    private int minlength = 0;

    public void setRequestBeanGetter(BeanGetter rbg) {
        this.rbg = rbg;
    }

    public UIJointContainer evolve(UIInputMany toevolve) {
        UIJointContainer togo = new UIJointContainer(toevolve.parent, toevolve.ID, COMPONENT_ID);
        toevolve.parent.remove((UIComponent)toevolve);
        toevolve.ID = "list-control";
        togo.addComponent((UIComponent)toevolve);
        String[] value = toevolve.getValue();
        if (UITypes.isPlaceholder((Object)value)) {
            value = (String[])this.rbg.getBean(toevolve.valuebinding.value);
            toevolve.setValue(value);
        }
        UIBranchContainer core = UIBranchContainer.make((UIContainer)togo, (String)CORE_ID);
        int limit = Math.max(this.minlength, value.length);
        for (int i = 0; i < limit; ++i) {
            UIBranchContainer row = UIBranchContainer.make((UIContainer)core, (String)"dynamic-list-input-row:", (String)Integer.toString(i));
            UIBasicListMember.makeBasic((UIContainer)row, (String)"input", (String)toevolve.getFullID(), (int)i);
            UIOutput.make((UIContainer)row, (String)"remove", (String)this.removelabel.getValue(), this.removelabel.valuebinding == null ? null : this.removelabel.valuebinding.value);
        }
        UIOutput.make((UIContainer)core, (String)"add-row", (String)this.addlabel.getValue(), this.addlabel.valuebinding == null ? null : this.addlabel.valuebinding.value);
        UIInitBlock.make((UIContainer)togo, (String)"init-script", (String)"DynamicListInput.init_DynamicListInput", (Object[])new Object[]{core, new Integer(limit), new Integer(this.minlength), new Integer(this.maxlength)});
        return togo;
    }

    public void setLabels(UIBoundString removelabel, UIBoundString addlabel) {
        this.removelabel = removelabel;
        this.addlabel = addlabel;
    }

    public void setMaximumLength(int maxlength) {
        this.maxlength = maxlength;
    }

    public void setMinimumLength(int minlength) {
        this.minlength = minlength;
    }
}

