/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.rsf.renderutil;

import uk.ac.cam.caret.rsf.renderutil.TableOptions;
import uk.org.ponder.htmlutil.HTMLUtil;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UIJointContainer;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.components.decorators.DecoratorList;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIDisabledDecorator;
import uk.org.ponder.rsf.viewstate.ViewParameters;

public class TableNavRenderer {
    public UIForm parameterForm;
    public UIVerbatim jscript;
    private int numHeaders = 0;
    private StringBuilder js = new StringBuilder();

    public TableNavRenderer(UIContainer tofill, String formID, String scriptID, ViewParameters vparams) {
        this.parameterForm = UIForm.make((UIContainer)tofill, (String)formID, (ViewParameters)vparams);
        this.jscript = UIVerbatim.make((UIContainer)tofill, (String)scriptID, (Object)"");
        this.jscript.markup = new StringBuilder();
        this.appendJS("theform = new SakaiProject.TableRenderer('" + this.parameterForm.getFullID() + "');");
    }

    protected void appendJS(String script) {
        StringBuilder sb = (StringBuilder)this.jscript.markup;
        sb.append(script);
    }

    public void makePager(UIContainer tofill, String divID, TableOptions options, int totalsize) {
        UIJointContainer joint = new UIJointContainer(tofill, divID, "standard-sakai-pager:", this.numHeaders + "");
        int pageNumber = options.acquireCurrentPage();
        int pageSize = options.acquirePageSize(20);
        int startItem = pageSize * pageNumber;
        int endItem = startItem + pageSize;
        if (options.acquireCurrentPage(totalsize) < 0) {
            int numberOfPages = totalsize / pageSize;
            if (totalsize % pageSize != 0) {
                ++numberOfPages;
            }
            startItem = pageSize * (numberOfPages - 1);
            endItem = totalsize;
        }
        UIOutput.make((UIContainer)joint, (String)"instructions:", (String)("Viewing " + (startItem + 1) + " to " + endItem + " of " + totalsize));
        String[] values = new String[]{"5", "10", "20", "50", "100", "200"};
        String[] labels = new String[]{"Show 5", "Show 10", "Show 20", "Show 50", "Show 100", "Show 200"};
        UISelect.make((UIContainer)joint, (String)"num-pages-select", (String[])values, (String[])labels, (String)(options.acquirePageSize(20) + ""), (boolean)false);
        UIOutput firstPageButton = UIOutput.make((UIContainer)joint, (String)"first-page-button");
        UIOutput prevPageButton = UIOutput.make((UIContainer)joint, (String)"prev-page-button");
        UIOutput nextPageButton = UIOutput.make((UIContainer)joint, (String)"next-page-button");
        UIOutput lastPageButton = UIOutput.make((UIContainer)joint, (String)"last-page-button");
        if (options.acquireCurrentPage(totalsize) == 0) {
            firstPageButton.decorators = new DecoratorList((UIDecorator)new UIDisabledDecorator());
            prevPageButton.decorators = new DecoratorList((UIDecorator)new UIDisabledDecorator());
        } else if (options.acquireCurrentPage(totalsize) < 0) {
            nextPageButton.decorators = new DecoratorList((UIDecorator)new UIDisabledDecorator());
            lastPageButton.decorators = new DecoratorList((UIDecorator)new UIDisabledDecorator());
        }
        this.appendJS(HTMLUtil.emitJavascriptCall((String)"theform.addSakaiPager", (String[])new String[]{joint.getFullID(), options.acquireCurrentPage() + "", options.acquirePageSize(20) + ""}));
        ++this.numHeaders;
    }

    public void makeSearchFilter(UIContainer tofill, String divID, String startingText) {
        UIJointContainer joint = new UIJointContainer(tofill, divID, "search-filter:", this.numHeaders + "");
        UIInput.make((UIContainer)joint, (String)"search-text-input", null, (String)startingText);
        UIOutput.make((UIContainer)joint, (String)"find-button");
        UIOutput.make((UIContainer)joint, (String)"clear-button");
        this.appendJS(HTMLUtil.emitJavascriptCall((String)"theform.addSearchFilter", (String[])new String[]{joint.getFullID(), startingText}));
        ++this.numHeaders;
    }

    public void makeSortableHeader(UIContainer tofill, String thID, String linktext, String sortid) {
        UIJointContainer joint = new UIJointContainer(tofill, thID, "theader:sort-link", this.numHeaders + "");
        UIOutput sortlink = UIOutput.make((UIContainer)joint, (String)"sort-link", (String)linktext);
        this.appendJS(HTMLUtil.emitJavascriptCall((String)"theform.addSortableHeader", (String[])new String[]{joint.getFullID(), sortid, "asc"}));
        ++this.numHeaders;
    }

    public void makeSortedHeader(UIContainer tofill, String thId, String linktext, String sortid, boolean curascending) {
        String newsortdir = curascending ? "asc" : "dsc";
        String cursortdir = curascending ? "dsc" : "asc";
        UIJointContainer joint = curascending ? new UIJointContainer(tofill, thId, "theader:cursort-asc-link", this.numHeaders + "") : new UIJointContainer(tofill, thId, "theader:cursort-dsc-link", this.numHeaders + "");
        UIOutput sortlink = UIOutput.make((UIContainer)joint, (String)"sort-link");
        UIOutput.make((UIContainer)joint, (String)"link-text", (String)linktext);
        this.appendJS(HTMLUtil.emitJavascriptCall((String)"theform.addSortedHeader", (String[])new String[]{joint.getFullID(), sortid, cursortdir, newsortdir}));
        ++this.numHeaders;
    }

    public void makeSortingHeader(UIContainer tofill, String thID, String linktext, String sortid, TableOptions tableoptions) {
        if (tableoptions.acquireSortColumn().equals(sortid)) {
            this.makeSortedHeader(tofill, thID, linktext, sortid, !tableoptions.acquireSortDirection());
        } else {
            this.makeSortableHeader(tofill, thID, linktext, sortid);
        }
    }
}

