/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.rsf.renderutil;

public class TableOptions {
    public static final String SHOWALL = "showall";
    public static final String LASTPAGE = "lastpage";
    public static final String SORTASC = "asc";
    public static final String SORTDSC = "dsc";
    public String pagenum = "";
    public String pagesize = "";
    public String filter = "";
    public String sortby = "";
    public String sortdir = "";

    public String toString() {
        return "Pagenum: " + this.pagenum + " Pagesize: " + this.pagesize + " Filter: " + this.filter + " Sortby: " + this.sortby + " Sortdir: " + this.sortdir;
    }

    public TableOptions() {
    }

    public TableOptions(int pagenum, int pagesize, String filter, String sortby, boolean sortasc) {
        this.updateCurrentPage(pagenum);
        this.updateItemsPerPage(pagesize);
        this.updateFilterText(filter);
        this.updateSortColumn(sortby);
        this.updateSortDirection(sortasc);
    }

    public boolean isInitialized() {
        return this.pagenum != null && !this.pagenum.equals("") || this.pagesize != null && !this.pagesize.equals("") || this.filter != null && !this.filter.equals("") || this.sortby != null && !this.sortby.equals("") || this.sortdir != null && !this.sortdir.equals("");
    }

    public String acquireFilterText(String fillerText) {
        String filtertext = this.filter != null && !this.filter.equals(fillerText) ? this.filter : null;
        return filtertext;
    }

    public void updateFilterText(String text) {
        this.filter = text;
    }

    public String acquireSortColumn(String defaultColumn) {
        String column = this.sortby == null || this.sortby.equals("") ? defaultColumn : this.sortby;
        return column;
    }

    public String acquireSortColumn() {
        return this.sortby;
    }

    public void updateSortColumn(String column) {
        this.sortby = column;
    }

    public boolean acquireSortDirection(boolean defaultSort) {
        if (this.sortdir != null && this.sortdir.equals(SORTASC)) {
            return true;
        }
        if (this.sortdir != null && this.sortdir.equals(SORTDSC)) {
            return false;
        }
        return defaultSort;
    }

    public boolean acquireSortDirection() {
        return this.acquireSortDirection(true);
    }

    public void updateSortDirection(boolean isascending) {
        this.sortdir = isascending ? SORTASC : SORTDSC;
    }

    public int acquirePageSize(int defaultSize) {
        try {
            if (this.pagesize == null || this.pagesize.equals("")) {
                return defaultSize;
            }
            if (this.pagesize.equals(SHOWALL)) {
                return -1;
            }
            int size = Integer.parseInt(this.pagesize);
            return size;
        }
        catch (NumberFormatException nfe) {
            return defaultSize;
        }
    }

    public void updateItemsPerPage(int size) {
        this.pagesize = size < 0 ? SHOWALL : size + "";
    }

    public int acquireCurrentPage() {
        try {
            if (this.pagenum == null || this.pagenum.equals("")) {
                return 0;
            }
            if (this.pagenum.equals(LASTPAGE)) {
                return -1;
            }
            return Integer.parseInt(this.pagenum);
        }
        catch (NumberFormatException nfr) {
            return 0;
        }
    }

    public int acquireCurrentPage(int totalNumberItems) {
        try {
            int realPageNum = this.acquireCurrentPage();
            int realPageSize = this.acquirePageSize(20);
            int numberOfPages = totalNumberItems / realPageSize;
            if (totalNumberItems % realPageSize != 0) {
                ++numberOfPages;
            }
            if (realPageNum >= numberOfPages - 1) {
                return -1;
            }
            return realPageNum;
        }
        catch (NumberFormatException nfr) {
            return 0;
        }
    }

    public void updateCurrentPage(int curpage) {
        this.pagenum = curpage < 0 ? LASTPAGE : curpage + "";
    }

    public int[] acquirePageRange() {
        return new int[]{0, 0};
    }
}

