/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.lightweightconfig.data;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import uk.org.webcompere.lightweightconfig.data.PlaceholderParser;

public class ImportAwarePlaceholderResolver {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("#import (.+)");

    public static Stream<String> processLine(String line, Function<String, Stream<String>> importOtherResource) {
        String interpolatedLine = PlaceholderParser.applyPlaceholders(line);
        Matcher matcher = IMPORT_PATTERN.matcher(interpolatedLine);
        if (matcher.matches()) {
            return importOtherResource.apply(matcher.group(1).trim());
        }
        return Stream.of(PlaceholderParser.applyPlaceholders(interpolatedLine));
    }
}

