/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.lightweightconfig.data;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.webcompere.lightweightconfig.regex.Regex;
import uk.org.webcompere.lightweightconfig.streams.Coalesce;

public class PlaceholderParser {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(?x)\\$\\{\n    (?<name>[0-9A-Za-z_.-]*)\n    (:-\n    (?<defaultvalue>[^}]*))?}");
    private static final String NAME_GROUP = "name";
    private static final String DEFAULT_VALUE_GROUP = "defaultvalue";

    public static String applyPlaceholders(String line) {
        return Regex.replaceTokens(line, PLACEHOLDER_PATTERN, PlaceholderParser::replacePlaceholder);
    }

    private static String replacePlaceholder(Matcher matcher) {
        String placeholderName = matcher.group(NAME_GROUP);
        return Coalesce.getFirstNonEmpty(() -> Optional.ofNullable(placeholderName).filter(String::isEmpty).map(name -> "$"), () -> Optional.ofNullable(System.getenv(placeholderName)), () -> Optional.ofNullable(System.getProperty(placeholderName)), () -> Optional.ofNullable(matcher.group(DEFAULT_VALUE_GROUP))).orElse("");
    }
}

