/*
 * Decompiled with CFR 0.152.
 */
package us.bryon.graphviz.maven;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.MojoExecutionException;
import us.bryon.graphviz.maven.AbstractDotMojo;

public class DotmlMojo
extends AbstractDotMojo {
    protected File basedir;
    protected String includes;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    @Override
    protected File getBasedir() {
        return this.basedir;
    }

    @Override
    protected String getIncludes() {
        return this.includes;
    }

    @Override
    protected File transformInputFile(File from) throws MojoExecutionException {
        File tempFile;
        try {
            tempFile = File.createTempFile("dotml-tmp", ".xml");
        }
        catch (IOException e) {
            throw new MojoExecutionException("error creating temp file to hold DOTML to DOT translation", (Exception)e);
        }
        StreamSource xml = new StreamSource(from);
        StreamResult result = new StreamResult(tempFile);
        try {
            StreamSource xslt = new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("dotml/dotml2dot.xsl"));
            this.transformerFactory.newTransformer(xslt).transform(xml, result);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException(String.format("error transforming %s from DOTML to DOT file", from), (Exception)e);
        }
        return tempFile;
    }
}

