/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import us.codecraft.webmagic.selector.CssSelector;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.SelectorFactory;
import us.codecraft.webmagic.selector.SmartContentSelector;
import us.codecraft.webmagic.selector.XpathSelector;

public class Html
extends PlainText {
    public Html(List<String> strings) {
        super(strings);
    }

    public Html(String text) {
        super(text);
    }

    public static Html create(String text) {
        return new Html(text);
    }

    @Override
    protected Selectable select(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            String result = selector.select(string);
            if (result == null) continue;
            results.add(result);
        }
        return new Html(results);
    }

    @Override
    protected Selectable selectList(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            List<String> result = selector.selectList(string);
            results.addAll(result);
        }
        return new Html(results);
    }

    @Override
    public Selectable smartContent() {
        SmartContentSelector smartContentSelector = SelectorFactory.getInstatnce().newSmartContentSelector();
        return this.select(smartContentSelector, this.strings);
    }

    @Override
    public Selectable links() {
        XpathSelector xpathSelector = SelectorFactory.getInstatnce().newXpathSelector("//a/@href");
        return this.selectList(xpathSelector, this.strings);
    }

    @Override
    public Selectable xpath(String xpath) {
        XpathSelector xpathSelector = SelectorFactory.getInstatnce().newXpathSelector(xpath);
        return this.selectList(xpathSelector, this.strings);
    }

    @Override
    public Selectable $(String selector) {
        CssSelector cssSelector = new CssSelector(selector);
        return this.selectList(cssSelector, this.strings);
    }

    @Override
    public Selectable $(String selector, String attrName) {
        CssSelector cssSelector = new CssSelector(selector, attrName);
        return this.selectList(cssSelector, this.strings);
    }
}

