/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.Scheduler;

public abstract class DuplicatedRemoveScheduler
implements Scheduler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void push(Request request, Task task) {
        this.logger.trace("get a candidate url {}", (Object)request.getUrl());
        if (this.isDuplicate(request, task) || this.shouldReserved(request)) {
            this.logger.debug("push to queue {}", (Object)request.getUrl());
            this.pushWhenNoDuplicate(request, task);
        }
    }

    public abstract void resetDuplicateCheck(Task var1);

    protected abstract boolean isDuplicate(Request var1, Task var2);

    protected boolean shouldReserved(Request request) {
        return request.getExtra("_cycle_tried_times") != null;
    }

    protected void pushWhenNoDuplicate(Request request, Task task) {
    }
}

