/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.jsoup.parser.TokenQueue;
import us.codecraft.webmagic.selector.JsonPathSelector;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;

public class Json
extends PlainText {
    public Json(List<String> strings) {
        super(strings);
    }

    public Json(String text) {
        super(text);
    }

    public Json removePadding(String padding) {
        String text = this.getText();
        TokenQueue tokenQueue = new TokenQueue(text);
        tokenQueue.consumeWhitespace();
        tokenQueue.consume(padding);
        tokenQueue.consumeWhitespace();
        String chompBalanced = tokenQueue.chompBalanced('(', ')');
        return new Json(chompBalanced);
    }

    public <T> T toObject(Class<T> clazz) {
        if (this.getText() == null) {
            return null;
        }
        return (T)JSON.parseObject((String)this.getText(), clazz);
    }

    public <T> List<T> toList(Class<T> clazz) {
        if (this.getText() == null) {
            return null;
        }
        return JSON.parseArray((String)this.getText(), clazz);
    }

    public String getText() {
        if (this.strings != null && this.strings.size() > 0) {
            return (String)this.strings.get(0);
        }
        return null;
    }

    @Override
    public Selectable jsonPath(String jsonPath) {
        JsonPathSelector jsonPathSelector = new JsonPathSelector(jsonPath);
        return this.selectList(jsonPathSelector, this.strings);
    }
}

