/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ws.schild.jave.EncoderException;
import ws.schild.jave.EncoderProgressListener;

public class ConversionOutputAnalyzer {
    private static final Log LOG = LogFactory.getLog(ConversionOutputAnalyzer.class);
    private static final Pattern PROGRESS_INFO_PATTERN = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\\S+)\\s*", 2);
    private final EncoderProgressListener listener;
    private final long duration;
    private int step = 0;
    private int lineNR = 0;
    private String lastWarning = null;
    private final List<String> unhandledMessages = new LinkedList<String>();

    public ConversionOutputAnalyzer(long duration, EncoderProgressListener listener) {
        this.duration = duration;
        this.listener = listener;
    }

    public void analyzeNewLine(String line) throws EncoderException {
        ++this.lineNR;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Input Line (" + this.lineNR + "): <" + line + ">"));
        }
        if (line.startsWith("WARNING: ") && this.listener != null) {
            this.listener.message(line);
        }
        if (!line.startsWith("Press [q]")) {
            switch (this.step) {
                case 0: {
                    if (!line.startsWith("Input #0")) break;
                    this.step = 1;
                    break;
                }
                case 1: {
                    if (line.startsWith("Stream mapping:")) {
                        this.step = 2;
                        break;
                    }
                    if (line.startsWith("Output #0")) {
                        this.step = 2;
                        break;
                    }
                    if (line.startsWith("  ")) break;
                    LOG.info((Object)("Unhandled message in step: " + this.step + " Line: " + this.lineNR + " message: <" + line + ">"));
                    this.unhandledMessages.add(line);
                    break;
                }
                case 2: {
                    if (line.startsWith("Output #0")) {
                        this.step = 3;
                        break;
                    }
                    if (line.startsWith("Stream mapping:")) {
                        this.step = 3;
                        break;
                    }
                    if (line.startsWith("  ")) break;
                    LOG.info((Object)("Unhandled message in step: " + this.step + " Line: " + this.lineNR + " message: <" + line + ">"));
                    this.unhandledMessages.add(line);
                    break;
                }
                case 3: {
                    if (line.startsWith("  ")) break;
                    if (line.startsWith("video:")) {
                        this.step = 4;
                        break;
                    }
                    if (line.startsWith("frame=") || line.startsWith("size=")) break;
                    if (line.endsWith("Queue input is backward in time") || line.contains("Application provided invalid, non monotonically increasing dts to muxer in stream")) {
                        if (this.listener == null) break;
                        this.listener.message(line);
                        break;
                    }
                    LOG.info((Object)("Unhandled message in step: " + this.step + " Line: " + this.lineNR + " message: <" + line + ">"));
                    this.unhandledMessages.add(line);
                }
            }
            if (line.startsWith("frame=") || line.startsWith("size=")) {
                try {
                    line = line.trim();
                    if (line.length() > 0) {
                        HashMap<String, String> table = this.parseProgressInfoLine(line);
                        if (table == null) {
                            if (this.listener != null) {
                                this.listener.message(line);
                            }
                            this.lastWarning = line;
                        } else {
                            String time;
                            if (this.listener != null && (time = table.get("time")) != null) {
                                int perm;
                                String[] dParts = time.split(":");
                                Double seconds = Double.parseDouble(dParts[dParts.length - 1]);
                                if (dParts.length > 1) {
                                    seconds = seconds + Double.parseDouble(dParts[dParts.length - 2]) * 60.0;
                                    if (dParts.length > 2) {
                                        seconds = seconds + Double.parseDouble(dParts[dParts.length - 3]) * 60.0 * 60.0;
                                    }
                                }
                                if ((perm = (int)Math.round(seconds * 1000.0 * 1000.0 / (double)this.duration)) > 1000) {
                                    perm = 1000;
                                }
                                this.listener.progress(perm);
                            }
                            this.lastWarning = null;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Error in progress parsing for line: " + line));
                }
            }
        }
    }

    public String getLastWarning() {
        return this.lastWarning;
    }

    private HashMap<String, String> parseProgressInfoLine(String line) {
        HashMap<String, String> table = null;
        Matcher m = PROGRESS_INFO_PATTERN.matcher(line);
        while (m.find()) {
            if (table == null) {
                table = new HashMap<String, String>();
            }
            String key = m.group(1);
            String value = m.group(2);
            table.put(key, value);
        }
        return table;
    }

    public List<String> getUnhandledMessages() {
        return this.unhandledMessages;
    }
}

