/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Encoder;

public class Base64Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected byte padding = (byte)61;
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n = 0;
        while (n < this.encodingTable.length) {
            this.decodingTable[this.encodingTable[n]] = (byte)n;
            ++n;
        }
    }

    public Base64Encoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] byArray, int n, int n2, OutputStream outputStream) throws IOException {
        int n3 = n2 % 3;
        int n4 = n2 - n3;
        int n5 = n;
        while (n5 < n + n4) {
            int n6 = byArray[n5] & 0xFF;
            int n7 = byArray[n5 + 1] & 0xFF;
            int n8 = byArray[n5 + 2] & 0xFF;
            outputStream.write(this.encodingTable[n6 >>> 2 & 0x3F]);
            outputStream.write(this.encodingTable[(n6 << 4 | n7 >>> 4) & 0x3F]);
            outputStream.write(this.encodingTable[(n7 << 2 | n8 >>> 6) & 0x3F]);
            outputStream.write(this.encodingTable[n8 & 0x3F]);
            n5 += 3;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                int n9 = byArray[n + n4] & 0xFF;
                int n10 = n9 >>> 2 & 0x3F;
                int n11 = n9 << 4 & 0x3F;
                outputStream.write(this.encodingTable[n10]);
                outputStream.write(this.encodingTable[n11]);
                outputStream.write(this.padding);
                outputStream.write(this.padding);
                break;
            }
            case 2: {
                int n12 = byArray[n + n4] & 0xFF;
                int n13 = byArray[n + n4 + 1] & 0xFF;
                int n14 = n12 >>> 2 & 0x3F;
                int n15 = (n12 << 4 | n13 >>> 4) & 0x3F;
                int n16 = n13 << 2 & 0x3F;
                outputStream.write(this.encodingTable[n14]);
                outputStream.write(this.encodingTable[n15]);
                outputStream.write(this.encodingTable[n16]);
                outputStream.write(this.padding);
            }
        }
        return n4 / 3 * 4 + (n3 == 0 ? 0 : 4);
    }

    private boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    /*
     * Unable to fully structure code
     */
    public int decode(byte[] var1_1, int var2_2, int var3_3, OutputStream var4_4) throws IOException {
        var9_5 = 0;
        var10_6 = var2_2 + var3_3;
        while (var10_6 > var2_2) {
            if (!this.ignore((char)var1_1[var10_6 - 1])) break;
            --var10_6;
        }
        var11_7 = var2_2;
        var12_8 = var10_6 - 4;
        ** GOTO lbl30
        {
            ++var11_7;
            do {
                if (var11_7 < var12_8 && this.ignore((char)var1_1[var11_7])) continue block1;
                var5_9 = this.decodingTable[var1_1[var11_7++]];
                while (var11_7 < var12_8 && this.ignore((char)var1_1[var11_7])) {
                    ++var11_7;
                }
                var6_10 = this.decodingTable[var1_1[var11_7++]];
                while (var11_7 < var12_8 && this.ignore((char)var1_1[var11_7])) {
                    ++var11_7;
                }
                var7_11 = this.decodingTable[var1_1[var11_7++]];
                while (var11_7 < var12_8 && this.ignore((char)var1_1[var11_7])) {
                    ++var11_7;
                }
                var8_12 = this.decodingTable[var1_1[var11_7++]];
                var4_4.write(var5_9 << 2 | var6_10 >> 4);
                var4_4.write(var6_10 << 4 | var7_11 >> 2);
                var4_4.write(var7_11 << 6 | var8_12);
                var9_5 += 3;
lbl30:
                // 2 sources

            } while (var11_7 < var12_8);
        }
        if (var1_1[var10_6 - 2] == this.padding) {
            var5_9 = this.decodingTable[var1_1[var10_6 - 4]];
            var6_10 = this.decodingTable[var1_1[var10_6 - 3]];
            var4_4.write(var5_9 << 2 | var6_10 >> 4);
            ++var9_5;
        } else if (var1_1[var10_6 - 1] == this.padding) {
            var5_9 = this.decodingTable[var1_1[var10_6 - 4]];
            var6_10 = this.decodingTable[var1_1[var10_6 - 3]];
            var7_11 = this.decodingTable[var1_1[var10_6 - 2]];
            var4_4.write(var5_9 << 2 | var6_10 >> 4);
            var4_4.write(var6_10 << 4 | var7_11 >> 2);
            var9_5 += 2;
        } else {
            var5_9 = this.decodingTable[var1_1[var10_6 - 4]];
            var6_10 = this.decodingTable[var1_1[var10_6 - 3]];
            var7_11 = this.decodingTable[var1_1[var10_6 - 2]];
            var8_12 = this.decodingTable[var1_1[var10_6 - 1]];
            var4_4.write(var5_9 << 2 | var6_10 >> 4);
            var4_4.write(var6_10 << 4 | var7_11 >> 2);
            var4_4.write(var7_11 << 6 | var8_12);
            var9_5 += 3;
        }
        return var9_5;
    }

    /*
     * Unable to fully structure code
     */
    public int decode(String var1_1, OutputStream var2_2) throws IOException {
        var7_3 = 0;
        var8_4 = var1_1.length();
        while (var8_4 > 0) {
            if (!this.ignore(var1_1.charAt(var8_4 - 1))) break;
            --var8_4;
        }
        var9_5 = 0;
        var10_6 = var8_4 - 4;
        ** GOTO lbl30
        {
            ++var9_5;
            do {
                if (var9_5 < var10_6 && this.ignore(var1_1.charAt(var9_5))) continue block1;
                var3_7 = this.decodingTable[var1_1.charAt(var9_5++)];
                while (var9_5 < var10_6 && this.ignore(var1_1.charAt(var9_5))) {
                    ++var9_5;
                }
                var4_8 = this.decodingTable[var1_1.charAt(var9_5++)];
                while (var9_5 < var10_6 && this.ignore(var1_1.charAt(var9_5))) {
                    ++var9_5;
                }
                var5_9 = this.decodingTable[var1_1.charAt(var9_5++)];
                while (var9_5 < var10_6 && this.ignore(var1_1.charAt(var9_5))) {
                    ++var9_5;
                }
                var6_10 = this.decodingTable[var1_1.charAt(var9_5++)];
                var2_2.write(var3_7 << 2 | var4_8 >> 4);
                var2_2.write(var4_8 << 4 | var5_9 >> 2);
                var2_2.write(var5_9 << 6 | var6_10);
                var7_3 += 3;
lbl30:
                // 2 sources

            } while (var9_5 < var10_6);
        }
        if (var1_1.charAt(var8_4 - 2) == this.padding) {
            var3_7 = this.decodingTable[var1_1.charAt(var8_4 - 4)];
            var4_8 = this.decodingTable[var1_1.charAt(var8_4 - 3)];
            var2_2.write(var3_7 << 2 | var4_8 >> 4);
            ++var7_3;
        } else if (var1_1.charAt(var8_4 - 1) == this.padding) {
            var3_7 = this.decodingTable[var1_1.charAt(var8_4 - 4)];
            var4_8 = this.decodingTable[var1_1.charAt(var8_4 - 3)];
            var5_9 = this.decodingTable[var1_1.charAt(var8_4 - 2)];
            var2_2.write(var3_7 << 2 | var4_8 >> 4);
            var2_2.write(var4_8 << 4 | var5_9 >> 2);
            var7_3 += 2;
        } else {
            var3_7 = this.decodingTable[var1_1.charAt(var8_4 - 4)];
            var4_8 = this.decodingTable[var1_1.charAt(var8_4 - 3)];
            var5_9 = this.decodingTable[var1_1.charAt(var8_4 - 2)];
            var6_10 = this.decodingTable[var1_1.charAt(var8_4 - 1)];
            var2_2.write(var3_7 << 2 | var4_8 >> 4);
            var2_2.write(var4_8 << 4 | var5_9 >> 2);
            var2_2.write(var5_9 << 6 | var6_10);
            var7_3 += 3;
        }
        return var7_3;
    }
}

