/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.classpath.InstanceOfFilter;
import org.milyn.classpath.IsAnnotationPresentFilter;
import org.milyn.classpath.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static Log logger = LogFactory.getLog(ClassUtil.class);
    private static final Map<String, Class> primitives = new HashMap<String, Class>();

    public static Class forName(String className, Class caller) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        Class primitiveClass = primitives.get(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        if (threadClassLoader != null) {
            try {
                return threadClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if ((classLoader = caller.getClassLoader()) != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return Class.forName(className, true, ClassLoader.getSystemClassLoader());
    }

    public static InputStream getResourceAsStream(String resourceName, Class caller) {
        InputStream is;
        InputStream is2;
        Package callerPackage;
        String resource = resourceName.startsWith("/") ? resourceName.substring(1) : ((callerPackage = caller.getPackage()) != null ? callerPackage.getName().replace('.', '/') + '/' + resourceName : resourceName);
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (is2 = threadClassLoader.getResourceAsStream(resource)) != null) {
            return is2;
        }
        ClassLoader classLoader = caller.getClassLoader();
        if (classLoader != null && (is = classLoader.getResourceAsStream(resource)) != null) {
            return is;
        }
        return ClassLoader.getSystemResourceAsStream(resource);
    }

    public static List<Class> findInstancesOf(Class type, String[] igrnoreList, String[] includeList) {
        InstanceOfFilter filter = new InstanceOfFilter(type, igrnoreList, includeList);
        return ClassUtil.findInstancesOf(type, filter);
    }

    public static List<Class> findInstancesOf(Class type) {
        InstanceOfFilter filter = new InstanceOfFilter(type);
        return ClassUtil.findInstancesOf(type, filter);
    }

    private static List<Class> findInstancesOf(Class type, InstanceOfFilter filter) {
        Scanner scanner = new Scanner(filter);
        try {
            long startTime = System.currentTimeMillis();
            scanner.scanClasspath(Thread.currentThread().getContextClassLoader());
            logger.info((Object)("Scanned classpath for instances of '" + type.getName() + "'.  Found " + filter.getClasses().size() + " matches. Scan took " + (System.currentTimeMillis() - startTime) + "ms."));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to search classspath for instances of '" + type.getName() + "'.", e);
        }
        return filter.getClasses();
    }

    public static List<Class> findAnnotatedWith(Class<? extends Annotation> type, String[] igrnoreList, String[] includeList) {
        IsAnnotationPresentFilter filter = new IsAnnotationPresentFilter(type, igrnoreList, includeList);
        return ClassUtil.findAnnotatedWith(type, filter);
    }

    public static List<Class> findAnnotatedWith(Class<? extends Annotation> type) {
        IsAnnotationPresentFilter filter = new IsAnnotationPresentFilter(type);
        return ClassUtil.findAnnotatedWith(type, filter);
    }

    private static List<Class> findAnnotatedWith(Class<? extends Annotation> type, IsAnnotationPresentFilter filter) {
        Scanner scanner = new Scanner(filter);
        try {
            long startTime = System.currentTimeMillis();
            scanner.scanClasspath(Thread.currentThread().getContextClassLoader());
            logger.info((Object)("Scanned classpath for class annotated with annotation '" + type.getName() + "'.  Found " + filter.getClasses().size() + " matches. Scan took " + (System.currentTimeMillis() - startTime) + "ms."));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to search classspath for class annotated with annotation '" + type.getName() + "'.", e);
        }
        return filter.getClasses();
    }

    public static Object newProxyInstance(Class[] classes, InvocationHandler handler) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null) {
            return Proxy.newProxyInstance(threadClassLoader, classes, handler);
        }
        return Proxy.newProxyInstance(ClassUtil.class.getClassLoader(), classes, handler);
    }

    public static <T> List<Class<T>> getClasses(String fileName, Class<T> instanceOf) {
        Enumeration<URL> cpURLs;
        AssertArgument.isNotNull(fileName, "fileName");
        AssertArgument.isNotNull(instanceOf, "instanceOf");
        long start = System.currentTimeMillis();
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        int resCount = 0;
        try {
            cpURLs = Thread.currentThread().getContextClassLoader().getResources(fileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting resource URLs for resource : " + fileName, e);
        }
        while (cpURLs.hasMoreElements()) {
            URL url = cpURLs.nextElement();
            ClassUtil.addClasses(url, instanceOf, classes);
            ++resCount;
        }
        logger.info((Object)("Loaded " + classes.size() + " classes from " + resCount + " URLs through class list file " + fileName + ".  Process took " + (System.currentTimeMillis() - start) + "ms.  Turn on debug logging for more info."));
        return classes;
    }

    private static <T> void addClasses(URL url, Class<T> instanceOf, List<Class<T>> classes) {
        InputStream ins = null;
        BufferedReader br = null;
        try {
            String className;
            int count = 0;
            URLConnection connection = url.openConnection();
            connection.setDefaultUseCaches(false);
            ins = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(ins));
            while ((className = br.readLine()) != null) {
                Class clazz;
                if ((className = className.trim()).equals("") || className.startsWith("#")) continue;
                try {
                    clazz = ClassUtil.forName(className, ClassUtil.class);
                }
                catch (ClassNotFoundException e) {
                    logger.warn((Object)("Failed to load class '" + className + "'. Class not found."));
                    continue;
                }
                if (instanceOf.isAssignableFrom(clazz)) {
                    if (!ClassUtil.contains(clazz.getName(), classes)) {
                        classes.add(clazz);
                    }
                    logger.debug((Object)("Adding " + className + " to list of classes"));
                    ++count;
                    continue;
                }
                logger.info((Object)("Not adding class '" + clazz.getName() + "' to list.  Class does not implement/extend '" + instanceOf.getName() + "'."));
            }
            logger.debug((Object)("Loaded '" + count + "' classes listed in '" + url + "'."));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to read from file : " + url, e);
            }
            catch (Throwable throwable) {
                ClassUtil.close(br);
                ClassUtil.close(ins);
                throw throwable;
            }
        }
        ClassUtil.close(br);
        ClassUtil.close(ins);
    }

    private static <T> boolean contains(String name, List<Class<T>> classes) {
        for (Class<T> aClass : classes) {
            if (!aClass.getName().equals(name)) continue;
            logger.debug((Object)("Class '" + name + "' already found on classpath.  Not adding to list."));
            return true;
        }
        return false;
    }

    private static void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Exception while trying to close : " + closable), (Throwable)e);
            }
        }
    }

    public static String toFilePath(Package aPackage) {
        return "/" + aPackage.getName().replace('.', '/');
    }

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("short", Short.TYPE);
    }
}

