/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp.test;

import com.jcraft.jsch.UserInfo;
import junit.framework.Test;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;

public class SftpProviderTestCase
extends AbstractProviderTestConfig {
    private static final String TEST_URI = "test.sftp.uri";

    public static Test suite() throws Exception {
        if (System.getProperty(TEST_URI) != null) {
            return new ProviderTestSuite(new SftpProviderTestCase());
        }
        return SftpProviderTestCase.notConfigured(SftpProviderTestCase.class);
    }

    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("sftp", (FileProvider)new SftpFileProvider());
    }

    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = System.getProperty(TEST_URI);
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(fileSystemOptions, "no");
        SftpFileSystemConfigBuilder.getInstance().setUserInfo(fileSystemOptions, (UserInfo)new TrustEveryoneUserInfo());
        return manager.resolveFile(uri, fileSystemOptions);
    }
}

