/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip.test;

import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;

public class NestedZipTestCase
extends AbstractProviderTestConfig
implements ProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new NestedZipTestCase(), true);
    }

    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("zip", (FileProvider)new ZipFileProvider());
        manager.addExtensionMap("zip", "zip");
        manager.addMimeTypeMap("application/zip", "zip");
    }

    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String zipFilePath = AbstractVfsTestCase.getTestResource("nested.zip").getAbsolutePath();
        String uri = "zip:file:" + zipFilePath + "!/test.zip";
        FileObject zipFile = manager.resolveFile(uri);
        FileObject nestedFS = manager.createFileSystem(zipFile);
        return nestedFS.resolveFile("/");
    }
}

