/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderWriteTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    public void testFolderCreate() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject folder = scratchFolder.resolveFile("dir1");
        ProviderWriteTests.assertTrue((!folder.exists() ? 1 : 0) != 0);
        folder.createFolder();
        ProviderWriteTests.assertTrue((boolean)folder.exists());
        ProviderWriteTests.assertSame((Object)FileType.FOLDER, (Object)folder.getType());
        ProviderWriteTests.assertEquals((int)0, (int)folder.getChildren().length);
        folder = scratchFolder.resolveFile("dir2/dir1/dir1");
        ProviderWriteTests.assertTrue((!folder.exists() ? 1 : 0) != 0);
        ProviderWriteTests.assertTrue((!folder.getParent().exists() ? 1 : 0) != 0);
        ProviderWriteTests.assertTrue((!folder.getParent().getParent().exists() ? 1 : 0) != 0);
        folder.createFolder();
        ProviderWriteTests.assertTrue((boolean)folder.exists());
        ProviderWriteTests.assertSame((Object)FileType.FOLDER, (Object)folder.getType());
        ProviderWriteTests.assertEquals((int)0, (int)folder.getChildren().length);
        ProviderWriteTests.assertTrue((boolean)folder.getParent().exists());
        ProviderWriteTests.assertTrue((boolean)folder.getParent().getParent().exists());
        ProviderWriteTests.assertTrue((boolean)folder.exists());
        folder.createFolder();
    }

    public void testFileCreate() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file.createFile();
        ProviderWriteTests.assertTrue((boolean)file.exists());
        ProviderWriteTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        ProviderWriteTests.assertEquals((long)0L, (long)file.getContent().getSize());
        ProviderWriteTests.assertFalse((boolean)file.isHidden());
        ProviderWriteTests.assertTrue((boolean)file.isReadable());
        ProviderWriteTests.assertTrue((boolean)file.isWriteable());
        file = scratchFolder.resolveFile("file1%25.txt");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file.createFile();
        ProviderWriteTests.assertTrue((boolean)file.exists());
        ProviderWriteTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        ProviderWriteTests.assertEquals((long)0L, (long)file.getContent().getSize());
        ProviderWriteTests.assertFalse((boolean)file.isHidden());
        ProviderWriteTests.assertTrue((boolean)file.isReadable());
        ProviderWriteTests.assertTrue((boolean)file.isWriteable());
        file = scratchFolder.resolveFile("dir1/dir1/file1.txt");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        ProviderWriteTests.assertTrue((!file.getParent().exists() ? 1 : 0) != 0);
        ProviderWriteTests.assertTrue((!file.getParent().getParent().exists() ? 1 : 0) != 0);
        file.createFile();
        ProviderWriteTests.assertTrue((boolean)file.exists());
        ProviderWriteTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        ProviderWriteTests.assertEquals((long)0L, (long)file.getContent().getSize());
        ProviderWriteTests.assertTrue((boolean)file.getParent().exists());
        ProviderWriteTests.assertTrue((boolean)file.getParent().getParent().exists());
        ProviderWriteTests.assertFalse((boolean)file.getParent().isHidden());
        ProviderWriteTests.assertFalse((boolean)file.getParent().getParent().isHidden());
        ProviderWriteTests.assertTrue((boolean)file.exists());
        file.createFile();
        ProviderWriteTests.assertTrue((boolean)file.exists());
        ProviderWriteTests.assertTrue((boolean)file.isReadable());
        ProviderWriteTests.assertTrue((boolean)file.isWriteable());
    }

    public void testFileCreateMismatched() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("dir1/file1.txt");
        file.createFile();
        ProviderWriteTests.assertEquals((Object)FileType.FILE, (Object)file.getType());
        FileObject folder = scratchFolder.resolveFile("dir1/dir2");
        folder.createFolder();
        ProviderWriteTests.assertEquals((Object)FileType.FOLDER, (Object)folder.getType());
        try {
            folder.createFile();
            ProviderWriteTests.fail();
        }
        catch (FileSystemException exc) {
            // empty catch block
        }
        try {
            file.createFolder();
            ProviderWriteTests.fail();
        }
        catch (FileSystemException exc) {
            // empty catch block
        }
        FileObject folder2 = file.resolveFile("some-child");
        try {
            folder2.createFolder();
            ProviderWriteTests.fail();
        }
        catch (FileSystemException exc) {
            // empty catch block
        }
    }

    public void testDelete() throws Exception {
        FileObject folder = this.createScratchFolder();
        folder.resolveFile("file1.txt").createFile();
        folder.resolveFile("file%25.txt").createFile();
        folder.resolveFile("emptydir").createFolder();
        folder.resolveFile("dir1/file1.txt").createFile();
        folder.resolveFile("dir1/dir2/file2.txt").createFile();
        FileObject file = folder.resolveFile("file1.txt");
        ProviderWriteTests.assertTrue((boolean)file.exists());
        file.delete(Selectors.SELECT_ALL);
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file = folder.resolveFile("file%25.txt");
        ProviderWriteTests.assertTrue((boolean)file.exists());
        file.delete(Selectors.SELECT_ALL);
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file = folder.resolveFile("emptydir");
        ProviderWriteTests.assertTrue((boolean)file.exists());
        file.delete(Selectors.SELECT_ALL);
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file = folder.resolveFile("dir1");
        FileObject file2 = file.resolveFile("dir2/file2.txt");
        ProviderWriteTests.assertTrue((boolean)file.exists());
        ProviderWriteTests.assertTrue((boolean)file2.exists());
        file.delete(Selectors.SELECT_ALL);
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        ProviderWriteTests.assertTrue((!file2.exists() ? 1 : 0) != 0);
        file = folder.resolveFile("some-folder/some-file");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file.delete(Selectors.SELECT_ALL);
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySameFileSystem() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        OutputStream os = file.getContent().getOutputStream();
        try {
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        finally {
            os.close();
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        FileObject fileCopy = scratchFolder.resolveFile("file1copy.txt");
        ProviderWriteTests.assertTrue((!fileCopy.exists() ? 1 : 0) != 0);
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverwriteSameFileSystem() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        OutputStream os = file.getContent().getOutputStream();
        try {
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        finally {
            os.close();
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        FileObject fileCopy = scratchFolder.resolveFile("file1copy.txt");
        ProviderWriteTests.assertTrue((!fileCopy.exists() ? 1 : 0) != 0);
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
        ProviderWriteTests.assertTrue((boolean)fileCopy.exists());
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDeleteCreateSameFileSystem() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderWriteTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        OutputStream os = file.getContent().getOutputStream();
        try {
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        finally {
            os.close();
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        FileObject fileCopy = scratchFolder.resolveFile("file1copy.txt");
        ProviderWriteTests.assertTrue((!fileCopy.exists() ? 1 : 0) != 0);
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
        ProviderWriteTests.assertTrue((boolean)fileCopy.exists());
        ProviderWriteTests.assertTrue((boolean)fileCopy.delete());
        ProviderWriteTests.assertTrue((!fileCopy.exists() ? 1 : 0) != 0);
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
    }

    public void testListChildren() throws Exception {
        FileObject folder = this.createScratchFolder();
        HashSet<String> names = new HashSet<String>();
        ProviderWriteTests.assertEquals((int)0, (int)folder.getChildren().length);
        folder.resolveFile("dir1").createFolder();
        names.add("dir1");
        this.assertSameFileSet(names, folder.getChildren());
        folder.resolveFile("file1.html").createFile();
        names.add("file1.html");
        this.assertSameFileSet(names, folder.getChildren());
        folder.resolveFile("dir2/file1.txt").createFile();
        names.add("dir2");
        this.assertSameFileSet(names, folder.getChildren());
        OutputStream outstr = folder.resolveFile("file2.txt").getContent().getOutputStream();
        outstr.close();
        names.add("file2.txt");
        this.assertSameFileSet(names, folder.getChildren());
        folder.resolveFile("dir1").delete(Selectors.SELECT_ALL);
        names.remove("dir1");
        this.assertSameFileSet(names, folder.getChildren());
        folder.resolveFile("file1.html").delete(Selectors.SELECT_ALL);
        names.remove("file1.html");
        this.assertSameFileSet(names, folder.getChildren());
        folder.delete(Selectors.SELECT_ALL);
        folder.createFolder();
        ProviderWriteTests.assertEquals((int)0, (int)folder.getChildren().length);
    }

    public void testListener() throws Exception {
        FileObject baseFile = this.createScratchFolder();
        FileObject child = baseFile.resolveFile("newfile.txt");
        ProviderWriteTests.assertTrue((!child.exists() ? 1 : 0) != 0);
        FileSystem fs = baseFile.getFileSystem();
        TestListener listener = new TestListener(child);
        fs.addListener(child, (FileListener)listener);
        listener.addCreateEvent();
        child.createFolder();
        listener.assertFinished();
        child.createFolder();
        listener.addDeleteEvent();
        child.delete();
        listener.assertFinished();
        child.delete();
        listener.addCreateEvent();
        child.createFile();
        listener.assertFinished();
        child.createFile();
        listener.addDeleteEvent();
        child.delete();
        listener.addCreateEvent();
        child.getContent().getOutputStream().close();
        listener.assertFinished();
        child.getContent().getOutputStream().close();
        FileObject otherChild = baseFile.resolveFile("folder1");
        otherChild.createFolder();
        listener.addDeleteEvent();
        listener.addCreateEvent();
        child.copyFrom(otherChild, Selectors.SELECT_SELF);
        listener.assertFinished();
        fs.removeListener(child, (FileListener)listener);
    }

    private void assertSameFileSet(Set<String> names, FileObject[] files) {
        ProviderWriteTests.assertEquals((int)names.size(), (int)files.length);
        for (int i = 0; i < files.length; ++i) {
            FileObject file = files[i];
            ProviderWriteTests.assertTrue((boolean)names.contains(file.getName().getBaseName()));
        }
    }

    private static class TestListener
    implements FileListener {
        private final FileObject file;
        private final ArrayList<Object> events = new ArrayList();
        private static final Object CREATE = "create";
        private static final Object DELETE = "delete";
        private static final Object CHANGED = "changed";

        public TestListener(FileObject file) {
            this.file = file;
        }

        public void fileCreated(FileChangeEvent event) {
            Assert.assertTrue((String)"Unexpected create event", (this.events.size() > 0 ? 1 : 0) != 0);
            Assert.assertSame((String)"Expecting a create event", (Object)CREATE, (Object)this.events.remove(0));
            Assert.assertSame((Object)this.file, (Object)event.getFile());
            try {
                Assert.assertTrue((boolean)this.file.exists());
            }
            catch (FileSystemException e) {
                Assert.fail();
            }
        }

        public void fileDeleted(FileChangeEvent event) {
            Assert.assertTrue((String)"Unexpected delete event", (this.events.size() > 0 ? 1 : 0) != 0);
            Assert.assertSame((String)"Expecting a delete event", (Object)DELETE, (Object)this.events.remove(0));
            Assert.assertSame((Object)this.file, (Object)event.getFile());
            try {
                Assert.assertTrue((!this.file.exists() ? 1 : 0) != 0);
            }
            catch (FileSystemException e) {
                Assert.fail();
            }
        }

        public void fileChanged(FileChangeEvent event) throws Exception {
            Assert.assertTrue((String)"Unexpected changed event", (this.events.size() > 0 ? 1 : 0) != 0);
            Assert.assertSame((String)"Expecting a changed event", (Object)CHANGED, (Object)this.events.remove(0));
            Assert.assertSame((Object)this.file, (Object)event.getFile());
            try {
                Assert.assertTrue((!this.file.exists() ? 1 : 0) != 0);
            }
            catch (FileSystemException e) {
                Assert.fail();
            }
        }

        public void addCreateEvent() {
            this.events.add(CREATE);
        }

        public void addDeleteEvent() {
            this.events.add(DELETE);
        }

        public void assertFinished() {
            Assert.assertEquals((String)"Missing event", (int)0, (int)this.events.size());
        }
    }
}

