/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class UriTests
extends AbstractProviderTestCase {
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.URI};
    }

    public void testAbsoluteURI() throws Exception {
        FileObject readFolder = this.getReadFolder();
        String uri = readFolder.getName().getURI();
        FileObject file = this.getManager().resolveFile(uri, readFolder.getFileSystem().getFileSystemOptions());
        UriTests.assertSame((String)"file object", (Object)readFolder, (Object)file);
        String rootUri = readFolder.getName().getRootURI();
        file = this.getManager().resolveFile(rootUri, readFolder.getFileSystem().getFileSystemOptions());
        UriTests.assertSame((Object)readFolder.getFileSystem().getRoot(), (Object)file);
        UriTests.assertEquals((String)rootUri, (String)file.getName().getRootURI());
        UriTests.assertEquals((String)rootUri, (String)file.getName().getURI());
        UriTests.assertEquals((String)"/", (String)file.getName().getPath());
    }
}

