/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.util.StringTokenizer;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftps.FtpsClientWrapper;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;

public class FtpsFileProvider
extends FtpFileProvider {
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        FileSystemOptions opts = new FileSystemOptions();
        if (name instanceof URLFileName) {
            if (fileSystemOptions != null) {
                opts = fileSystemOptions;
            }
            String queryString = ((URLFileName)name).getQueryString();
            FtpsFileSystemConfigBuilder cfgBuilder = FtpsFileSystemConfigBuilder.getInstance();
            StringTokenizer st = new StringTokenizer(queryString, "?&!=");
            while (st.hasMoreTokens()) {
                if (!"vfs.passive".equalsIgnoreCase(st.nextToken()) || !st.hasMoreTokens() || !"true".equalsIgnoreCase(st.nextToken())) continue;
                cfgBuilder.setPassiveMode(opts, true);
            }
        }
        FtpsClientWrapper ftpClient = new FtpsClientWrapper(rootName, opts);
        return new FtpFileSystem(rootName, ftpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpsFileSystemConfigBuilder.getInstance();
    }
}

