/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

class FTPClientWrapper
implements FtpClient {
    private static final Log log = LogFactory.getLog(FTPClientWrapper.class);
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPClient ftpClient;

    FTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), rootName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPClient;
    }

    private synchronized FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        if (this.root.getURI().contains("vfs.passive=true") && this.ftpClient.getDataConnectionMode() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"FTP Client is entering into passive mode.");
            }
            this.ftpClient.enterLocalPassiveMode();
        }
        return this.ftpClient;
    }

    public boolean isConnected() throws FileSystemException {
        return this.ftpClient != null && this.ftpClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            FTPFile[] files = this.listFilesInDirectory(relPath);
            return files;
        }
        catch (IOException e) {
            this.disconnect();
            FTPFile[] files = this.listFilesInDirectory(relPath);
            return files;
        }
    }

    private FTPFile[] listFilesInDirectory(String relPath) throws IOException {
        FTPFile[] files = this.getFtpClient().listFiles(relPath);
        if (FTPReply.isPositiveCompletion((int)this.getFtpClient().getReplyCode())) {
            return files;
        }
        String workingDirectory = null;
        if (relPath != null) {
            workingDirectory = this.getFtpClient().printWorkingDirectory();
            if (!this.getFtpClient().changeWorkingDirectory(relPath)) {
                return null;
            }
        }
        files = this.getFtpClient().listFiles();
        if (relPath != null && !this.getFtpClient().changeWorkingDirectory(workingDirectory)) {
            throw new FileSystemException("vfs.provider.ftp.wrapper/change-work-directory-back.error", workingDirectory);
        }
        return files;
    }

    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }

    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }
}

