/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.receivers.RawXMLINOnlyMessageReceiver;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class MessageContextPropertyTest
extends SandeshaTestCase {
    private final String TEST_OPERATION_NAME = "testOperation";
    private final String applicationNamespaceName = "http://tempuri.org/";
    private final String Text = "Text";

    public MessageContextPropertyTest() {
        super("MessageContextPropertyTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        AxisService axisService = axisConfiguration.getService("RMSampleService");
        AxisOperation operation = AxisOperationFactory.getAxisOperation((int)10);
        operation.setMessageReceiver((MessageReceiver)new TestMessageReceiver());
        operation.setName(new QName("testOperation"));
        axisService.addOperation(operation);
        AxisOperation pingOperation = axisService.getOperation(new QName("ping"));
        if (pingOperation == null) {
            throw new AxisFault("Cant find the ping operation");
        }
        operation.setRemainingPhasesInFlow(pingOperation.getRemainingPhasesInFlow());
        this.httpServer = new SimpleHTTPServer(configContext, this.serverPort);
        this.httpServer.start();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            throw new SandeshaException("sleep interupted");
        }
    }

    public void testParameters() throws AxisFault, InterruptedException {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = "sequence1";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getTestOperationOMBlock("ping1"));
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        serviceClient.fireAndForget(this.getTestOperationOMBlock("ping2"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                MessageContextPropertyTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(2L)));
                MessageContextPropertyTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)3);
                MessageContextPropertyTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    private OMElement getTestOperationOMBlock(String text) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace("http://tempuri.org/", "ns1");
        OMElement pingElem = fac.createOMElement("testOperation", namespace);
        OMElement textElem = fac.createOMElement("Text", namespace);
        textElem.setText(text);
        pingElem.addChild((OMNode)textElem);
        return pingElem;
    }

    private class TestMessageReceiver
    extends RawXMLINOnlyMessageReceiver {
        Long lastReceivedMessage = null;
        String sequenceId = null;

        private TestMessageReceiver() {
        }

        public void invokeBusinessLogic(MessageContext msgContext) {
            Long msgNo = (Long)msgContext.getProperty("WSRMMessageNumber");
            String sequenceId = (String)msgContext.getProperty("WSRMSequenceId");
            Assert.assertNotNull((Object)msgNo);
            Assert.assertNotNull((Object)sequenceId);
            if (this.lastReceivedMessage == null) {
                Assert.assertEquals((Object)msgNo, (Object)new Long(1L));
            } else {
                Assert.assertEquals((Object)msgNo, (Object)new Long(2L));
            }
            if (this.sequenceId != null) {
                Assert.assertEquals((String)this.sequenceId, (String)sequenceId);
            }
            this.sequenceId = sequenceId;
            this.lastReceivedMessage = msgNo;
        }
    }
}

