/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.util.PropertyManager;

public class PropertyLoaderTest
extends TestCase {
    SandeshaPolicyBean propertyBean = null;

    public void setUp() {
        String fileName = "target" + File.separator + "test-classes" + File.separator + "sandesha2.properties";
        File file = new File(fileName);
        if (!file.exists()) {
            PropertyLoaderTest.fail((String)"sandesha2.properties file was not found");
        }
        try {
            FileInputStream in = new FileInputStream(file);
            this.propertyBean = PropertyManager.loadPropertiesFromPropertyFile((InputStream)in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            PropertyLoaderTest.fail((String)e.getMessage());
        }
    }

    public void testRetransmissionInterval() throws SandeshaException {
        long value = this.propertyBean.getRetransmissionInterval();
        PropertyLoaderTest.assertEquals((long)value, (long)20000L);
    }

    public void testExponentialBackOff() throws SandeshaException {
        boolean value = this.propertyBean.isExponentialBackoff();
        PropertyLoaderTest.assertEquals((boolean)value, (boolean)false);
    }

    public void testAcknowledgementInterval() throws SandeshaException {
        long value = this.propertyBean.getAcknowledgementInterval();
        PropertyLoaderTest.assertEquals((long)value, (long)8000L);
    }

    public void testInactivityTImeout() {
        long value = this.propertyBean.getInactivityTimeoutInterval();
        PropertyLoaderTest.assertEquals((long)value, (long)10800000L);
    }

    public void testStorageManager() {
        String storageMgr = this.propertyBean.getInMemoryStorageManagerClass();
        PropertyLoaderTest.assertEquals((String)storageMgr, (String)"org.apache.sandesha2.storage.inmemory.InMemoryStorageManager1");
    }

    public void testSecurityManager() {
        String secMgr = this.propertyBean.getSecurityManagerClass();
        PropertyLoaderTest.assertEquals((String)secMgr, (String)"org.apache.sandesha2.security.SecurityManager1");
    }

    public void testSequenceRemovalTimeout() {
        long value = this.propertyBean.getSequenceRemovalTimeoutInterval();
        PropertyLoaderTest.assertEquals((long)3600000L, (long)value);
    }
}

