/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class SandeshaClientLastErrorTest
extends SandeshaTestCase {
    String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";

    public SandeshaClientLastErrorTest() {
        super("SandeshaClientTest");
    }

    public void testLastErrorAndTimestamp() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String transportTo = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty("TransportURL", (Object)transportTo);
        String sequenceKey = "sequence1";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                Exception lastSendError = SandeshaClient.getLastSendError((ServiceClient)serviceClient);
                long lastSendErrorTime = SandeshaClient.getLastSendErrorTimestamp((ServiceClient)serviceClient);
                SandeshaClientLastErrorTest.assertNotNull((Object)lastSendError);
                SandeshaClientLastErrorTest.assertTrue((lastSendErrorTime > -1L ? 1 : 0) != 0);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        this.startServer(this.server_repoPath, this.server_axis2_xml);
        serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
        limit = System.currentTimeMillis() + (long)this.waitTime;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SandeshaClientLastErrorTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(1L)));
                SandeshaClientLastErrorTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(2L)));
                SandeshaClientLastErrorTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        SandeshaClient.terminateSequence((ServiceClient)serviceClient, (String)sequenceKey);
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

