/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import java.util.List;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisDescription;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class SandeshaClientTest
extends SandeshaTestCase {
    String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
    private boolean startedServer = false;

    public SandeshaClientTest() {
        super("SandeshaClientTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        if (!this.startedServer) {
            this.startServer(repoPath, axis2_xml);
        }
        this.startedServer = true;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSequenceWithOffer() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String transportTo = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty("TransportURL", (Object)transportTo);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        try {
            String acksTo = serviceClient.getMyEPR("http").getAddress();
            clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
            clientOptions.setTransportInProtocol("http");
            String offeredSequenceID = SandeshaUtil.getUUID();
            clientOptions.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)offeredSequenceID);
            serviceClient.setOptions(clientOptions);
            clientOptions.setTransportInProtocol("http");
            clientOptions.setUseSeparateListener(true);
            serviceClient.setOptions(clientOptions);
            String sequenceKey = SandeshaClient.createSequence((ServiceClient)serviceClient, (boolean)true);
            clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
            long limit = System.currentTimeMillis() + (long)this.waitTime;
            Error lastError = null;
            while (System.currentTimeMillis() < limit) {
                Thread.sleep(this.tickTime);
                try {
                    SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                    SandeshaClientTest.assertNotNull((Object)sequenceReport.getSequenceID());
                    SandeshaClientTest.assertFalse((boolean)sequenceReport.isSecureSequence());
                    lastError = null;
                    break;
                }
                catch (Error e) {
                    lastError = e;
                }
            }
            if (lastError != null) {
                throw lastError;
            }
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequenceCloseTerminate() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = "some_sequence_key";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        String acksTo = serviceClient.getMyEPR("http").getAddress();
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        serviceClient.setOptions(clientOptions);
        try {
            serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
            long limit = System.currentTimeMillis() + (long)this.waitTime;
            Error lastError = null;
            while (System.currentTimeMillis() < limit) {
                Thread.sleep(this.tickTime);
                try {
                    SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                    SandeshaClientTest.assertNotNull((Object)sequenceReport.getSequenceID());
                    SandeshaClient.closeSequence((ServiceClient)serviceClient);
                    try {
                        serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
                        SandeshaClientTest.fail();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.terminateAndCheck(serviceClient);
                    lastError = null;
                    break;
                }
                catch (Error e) {
                    lastError = e;
                }
            }
            if (lastError != null) {
                throw lastError;
            }
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }

    private void terminateAndCheck(ServiceClient srvcClient) throws Exception {
        SandeshaClient.terminateSequence((ServiceClient)srvcClient);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport report = SandeshaClient.getOutgoingSequenceReport((ServiceClient)srvcClient);
                SandeshaClientTest.assertNotNull((Object)report);
                SandeshaClientTest.assertEquals((byte)report.getSequenceStatus(), (byte)3);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTerminateCreateWithWait() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        clientOptions.setTo(new EndpointReference(to));
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        String acksTo = serviceClient.getMyEPR("http").getAddress();
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        serviceClient.setOptions(clientOptions);
        try {
            serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
            SandeshaClient.terminateSequence((ServiceClient)serviceClient);
            SandeshaClient.waitUntilSequenceCompleted((ServiceClient)serviceClient, (long)30000L);
            SandeshaClient.createSequence((ServiceClient)serviceClient, (boolean)false, null);
            serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
            SandeshaClient.terminateSequence((ServiceClient)serviceClient);
            SandeshaClient.waitUntilSequenceCompleted((ServiceClient)serviceClient, (long)30000L);
            SequenceReport report = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
            SandeshaClientTest.assertNotNull((Object)report);
            SandeshaClientTest.assertEquals((byte)3, (byte)report.getSequenceStatus());
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }

    public void testAckRequest() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String transportTo = "http://127.0.0.1:8070/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty("TransportURL", (Object)transportTo);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        clientOptions.setUseSeparateListener(true);
        serviceClient.setOptions(clientOptions);
        SandeshaClient.createSequence((ServiceClient)serviceClient, (boolean)false, null);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport report = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SandeshaClientTest.assertEquals((byte)report.getSequenceStatus(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        SandeshaClient.sendAckRequest((ServiceClient)serviceClient);
        limit = System.currentTimeMillis() + (long)this.waitTime;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)configContext, (AxisDescription)configContext.getAxisConfiguration());
                String sequenceId = SandeshaClient.getSequenceID((ServiceClient)serviceClient);
                SenderBeanMgr senderManager = storageManager.getSenderBeanMgr();
                Transaction transaction = storageManager.getTransaction();
                SenderBean senderBean = new SenderBean();
                senderBean.setSequenceID(sequenceId);
                senderBean.setSend(true);
                senderBean.setReSend(false);
                List beans = senderManager.find(senderBean);
                SandeshaClientTest.assertTrue((String)"SenderBeans found when the list should be empty", (beans.size() == 1 ? 1 : 0) != 0);
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                transaction.commit();
                SandeshaClientTest.assertNotNull((Object)sequenceReport.getSequenceID());
                SandeshaClientTest.assertFalse((boolean)sequenceReport.isSecureSequence());
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

