/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SandeshaTestCase
extends TestCase {
    String resourceDir = "";
    Properties properties = null;
    final String PROPERTY_FILE_NAME = "sandesha2-test.properties";
    public final int DEFAULT_SERVER_TEST_PORT = 8060;
    public ConfigurationContext serverConfigurationContext = null;
    private final String RMServiceName = "RMSampleService";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String applicationNamespaceName = "http://tempuri.org/";
    private static final String echoString = "echoString";
    private static final String ping = "ping";
    private static final String Text = "Text";
    private static final String Sequence = "Sequence";
    private static final String echoStringResponse = "echoStringResponse";
    private static final String EchoStringReturn = "EchoStringReturn";
    protected SimpleHTTPServer httpServer = null;
    protected int serverPort = 8060;
    protected int waitTime = 60000;
    protected int tickTime = 1000;
    protected String pingAction = "urn:wsrm:Ping";
    protected String echoAction = "urn:wsrm:EchoString";

    public SandeshaTestCase(String name) {
        super(name);
        String testRource = "target" + File.separator + "test-classes";
        this.resourceDir = new File(testRource).getPath();
        String propFileStr = this.resourceDir + File.separator + "sandesha2-test.properties";
        this.properties = new Properties();
        try {
            FileInputStream propertyFile = new FileInputStream(new File(propFileStr));
            this.properties.load(propertyFile);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        String serverPortStr = this.getTestProperty("test.server.port");
        if (serverPortStr != null) {
            try {
                this.serverPort = Integer.parseInt(serverPortStr);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)e);
            }
        }
    }

    public ConfigurationContext startServer(String repoPath, String axis2_xml) throws Exception {
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        this.httpServer = new SimpleHTTPServer(configContext, this.serverPort);
        this.httpServer.start();
        Thread.sleep(300L);
        return configContext;
    }

    public void tearDown() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        Thread.sleep(300L);
    }

    protected InputStreamReader getResource(String relativePath, String resourceName) {
        String resourceFile = this.resourceDir + relativePath + File.separator + resourceName;
        try {
            FileReader reader = new FileReader(resourceFile);
            return reader;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("cannot load the test-resource", e);
        }
    }

    protected SOAPEnvelope getSOAPEnvelope() {
        return OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope();
    }

    protected SOAPEnvelope getSOAPEnvelope(String relativePath, String resourceName) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(this.getResource(relativePath, resourceName));
            StAXSOAPModelBuilder wrapper = OMXMLBuilderFactory.createStAXSOAPModelBuilder((SOAPFactory)OMAbstractFactory.getSOAP11Factory(), (XMLStreamReader)reader);
            return (SOAPEnvelope)wrapper.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected SOAPEnvelope getEmptySOAPEnvelope() {
        return OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope();
    }

    protected static OMElement getEchoOMBlock(String text, String sequenceKey) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace applicationNamespace = fac.createOMNamespace(applicationNamespaceName, "ns1");
        OMElement echoStringElement = fac.createOMElement(echoString, applicationNamespace);
        OMElement textElem = fac.createOMElement(Text, applicationNamespace);
        OMElement sequenceElem = fac.createOMElement(Sequence, applicationNamespace);
        textElem.setText(text);
        sequenceElem.setText(sequenceKey);
        echoStringElement.addChild((OMNode)textElem);
        echoStringElement.addChild((OMNode)sequenceElem);
        return echoStringElement;
    }

    protected OMElement getPingOMBlock(String text) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace(applicationNamespaceName, "ns1");
        OMElement pingElem = fac.createOMElement(ping, namespace);
        OMElement textElem = fac.createOMElement(Text, namespace);
        textElem.setText(text);
        pingElem.addChild((OMNode)textElem);
        return pingElem;
    }

    protected String checkEchoOMBlock(OMElement response) {
        SandeshaTestCase.assertEquals((String)"Response namespace", (String)applicationNamespaceName, (String)response.getNamespace().getNamespaceURI());
        SandeshaTestCase.assertEquals((String)"Response local name", (String)echoStringResponse, (String)response.getLocalName());
        OMElement echoStringReturnElem = response.getFirstChildWithName(new QName(applicationNamespaceName, EchoStringReturn));
        SandeshaTestCase.assertNotNull((String)"Echo String Return", (Object)echoStringReturnElem);
        String resultStr = echoStringReturnElem.getText();
        return resultStr;
    }

    public String getTestProperty(String key) {
        if (this.properties != null) {
            return this.properties.getProperty(key);
        }
        return null;
    }

    public void overrideConfigurationContext(ConfigurationContext context, MessageReceiver messageReceiver, String operationName, boolean newOperation, int mep) throws Exception {
        AxisService rmService = context.getAxisConfiguration().getService("RMSampleService");
        AxisOperation operation = null;
        if (newOperation) {
            operation = rmService.getOperation(new QName(operationName));
            if (operation == null) {
                throw new Exception("Given operation not found");
            }
        } else {
            operation = AxisOperationFactory.getAxisOperation((int)mep);
            rmService.addOperation(operation);
        }
        operation.setMessageReceiver(messageReceiver);
    }

    protected class TestCallback
    implements AxisCallback {
        String name = null;
        boolean completed = false;
        boolean errorReported = false;
        String resultStr;

        public boolean isComplete() {
            return this.completed;
        }

        public boolean isErrorReported() {
            return this.errorReported;
        }

        public String getResult() {
            return this.resultStr;
        }

        public TestCallback(String name) {
            this.name = name;
        }

        public void onComplete() {
            this.completed = true;
        }

        public void onMessage(MessageContext result) {
            SOAPBody body = result.getEnvelope().getBody();
            OMElement contents = body.getFirstElement();
            this.resultStr = SandeshaTestCase.this.checkEchoOMBlock(contents);
        }

        public void onFault(MessageContext result) {
            this.errorReported = true;
        }

        public void onError(Exception e) {
            this.errorReported = true;
        }
    }
}

