/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.wsrm.AcknowledgementRange;

public class SandeshaUtilTest
extends TestCase {
    public void testUUIDGen() {
        String UUID1 = SandeshaUtil.getUUID();
        String UUID2 = SandeshaUtil.getUUID();
        SandeshaUtilTest.assertTrue((UUID1 != null ? 1 : 0) != 0);
        SandeshaUtilTest.assertTrue((UUID2 != null ? 1 : 0) != 0);
        SandeshaUtilTest.assertTrue((!UUID1.equals(UUID2) ? 1 : 0) != 0);
        SandeshaUtilTest.assertTrue((boolean)UUID1.startsWith("urn:uuid:"));
        SandeshaUtilTest.assertTrue((boolean)UUID2.startsWith("urn:uuid:"));
    }

    public void testInternalSequenceIDToSequenceKeyConversion() {
        String toEPR = "http://127.0.0.1:1111/some_random_uri";
        String sequenceKey = "1234abcd";
        String internalSequenceID = SandeshaUtil.getInternalSequenceID((String)toEPR, (String)sequenceKey);
        SandeshaUtilTest.assertEquals((String)sequenceKey, (String)SandeshaUtil.getSequenceKeyFromInternalSequenceID((String)internalSequenceID, (String)toEPR));
        internalSequenceID = SandeshaUtil.getSequenceKeyFromInternalSequenceID((String)toEPR, null);
        SandeshaUtilTest.assertNull((Object)SandeshaUtil.getSequenceKeyFromInternalSequenceID((String)internalSequenceID, (String)toEPR));
        String outgoingSequenceID = SandeshaUtil.getOutgoingSideInternalSequenceID((String)SandeshaUtil.getUUID());
        SandeshaUtilTest.assertNull((Object)SandeshaUtil.getSequenceKeyFromInternalSequenceID((String)outgoingSequenceID, (String)toEPR));
    }

    public void testGetAckRangesFromRangeStringOutOfOrder() throws SandeshaException {
        RangeString rangeString = new RangeString();
        rangeString.addRange(new Range(3L));
        rangeString.addRange(new Range(6L));
        rangeString.addRange(new Range(1L));
        rangeString.addRange(new Range(5L));
        rangeString.addRange(new Range(8L));
        rangeString.addRange(new Range(2L));
        ArrayList list = SandeshaUtil.getAckRangeArrayList((RangeString)rangeString, (String)"http://schemas.xmlsoap.org/ws/2005/02/rm");
        SandeshaUtilTest.assertNotNull((Object)list);
        SandeshaUtilTest.assertEquals((int)list.size(), (int)3);
        Iterator it = list.iterator();
        AcknowledgementRange ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)1L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)3L);
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)5L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)6L);
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)8L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)8L);
        SandeshaUtilTest.assertFalse((boolean)it.hasNext());
    }

    public void testGetAckRangesFromRangeStringGapFilling() throws SandeshaException {
        RangeString rangeString = new RangeString();
        rangeString.addRange(new Range(1L, 3L));
        rangeString.addRange(new Range(4L));
        rangeString.addRange(new Range(6L));
        rangeString.addRange(new Range(9L, 10L));
        ArrayList list = SandeshaUtil.getAckRangeArrayList((RangeString)rangeString, (String)"http://schemas.xmlsoap.org/ws/2005/02/rm");
        SandeshaUtilTest.assertNotNull((Object)list);
        SandeshaUtilTest.assertEquals((int)list.size(), (int)3);
        Iterator it = list.iterator();
        AcknowledgementRange ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)1L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)4L);
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)6L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)6L);
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)9L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)10L);
        SandeshaUtilTest.assertFalse((boolean)it.hasNext());
        rangeString.addRange(new Range(5L));
        list = SandeshaUtil.getAckRangeArrayList((RangeString)rangeString, (String)"http://schemas.xmlsoap.org/ws/2005/02/rm");
        SandeshaUtilTest.assertNotNull((Object)list);
        it = list.iterator();
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)1L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)6L);
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)9L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)10L);
        SandeshaUtilTest.assertFalse((boolean)it.hasNext());
        rangeString.addRange(new Range(8L));
        rangeString.addRange(new Range(7L, 8L));
        list = SandeshaUtil.getAckRangeArrayList((RangeString)rangeString, (String)"http://schemas.xmlsoap.org/ws/2005/02/rm");
        SandeshaUtilTest.assertNotNull((Object)list);
        it = list.iterator();
        ackRange = null;
        ackRange = (AcknowledgementRange)it.next();
        SandeshaUtilTest.assertNotNull((Object)ackRange);
        SandeshaUtilTest.assertEquals((long)ackRange.getLowerValue(), (long)1L);
        SandeshaUtilTest.assertEquals((long)ackRange.getUpperValue(), (long)10L);
        SandeshaUtilTest.assertFalse((boolean)it.hasNext());
    }

    public void testCreateFaultMessageContext() throws Exception {
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(configContext);
        messageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)messageContext, (Throwable)new Exception());
    }
}

