/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import java.util.List;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaReport;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.util.SandeshaUtil;

public class SquenceOfferTest
extends SandeshaTestCase {
    public SquenceOfferTest() {
        super("SquenceOfferTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        this.startServer(repoPath, axis2_xml);
    }

    public void testSequenceOffer() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        String acksTo = serviceClient.getMyEPR("http").getAddress();
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        String offeredSequenceID = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)offeredSequenceID);
        serviceClient.setOptions(clientOptions);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        serviceClient.setOptions(clientOptions);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(SquenceOfferTest.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SquenceOfferTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(1L)));
                SquenceOfferTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)3);
                SquenceOfferTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                SquenceOfferTest.assertTrue((boolean)callback1.isComplete());
                SquenceOfferTest.assertEquals((String)callback1.getResult(), (String)"echo1");
                SandeshaReport rmReport = SandeshaClient.getSandeshaReport((ConfigurationContext)configContext);
                List incomingSeqList = rmReport.getIncomingSequenceList();
                SquenceOfferTest.assertEquals((int)incomingSeqList.size(), (int)1);
                SquenceOfferTest.assertEquals(incomingSeqList.get(0), (Object)offeredSequenceID);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

