/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.faulttests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.faulttests.FaultTestUtils;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class InvalidAcknowledgementTest
extends SandeshaTestCase {
    private static final String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    private static final String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
    private ConfigurationContext serverConfigContext;

    public InvalidAcknowledgementTest() {
        super("InvalidAcknowledgementTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.serverConfigContext = this.startServer(server_repoPath, server_axis2_xml);
    }

    public void testInvalidAcknowledgementSOAPFault() throws Exception {
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)this.serverConfigContext, (AxisDescription)this.serverConfigContext.getAxisConfiguration());
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        String seqID = SandeshaUtil.getUUID();
        RMSBean rmsBean = new RMSBean();
        rmsBean.setCreateSeqMsgID(SandeshaUtil.getUUID());
        rmsBean.setSequenceID(seqID);
        rmsBean.setInternalSequenceID(SandeshaUtil.getInternalSequenceID((String)seqID, null));
        rmsBean.setToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmsBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmsBean.setReplyToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmsBean.setRMVersion("Spec_2007_02");
        rmsBean.setClientCompletedMessages(new RangeString());
        rmsBean.setNextMessageNumber(1L);
        Transaction tran = storageManager.getTransaction();
        rmsBeanMgr.insert(rmsBean);
        tran.commit();
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement");
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getAppMessageAsBytes(seqID);
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        InvalidAcknowledgementTest.assertNotNull((Object)message);
        InvalidAcknowledgementTest.assertTrue((message.indexOf("InvalidAcknowledgement") > -1 ? 1 : 0) != 0);
        String faultID = message.substring(message.indexOf("<wsrm:Identifier>") + 17, message.indexOf("</wsrm:Identifier>"));
        InvalidAcknowledgementTest.assertEquals((String)seqID, (String)faultID);
        connection.disconnect();
    }

    public void testInvalidAcknowledgementFromBeanNotSentSOAPFault() throws Exception {
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)this.serverConfigContext, (AxisDescription)this.serverConfigContext.getAxisConfiguration());
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        SenderBeanMgr senderMgr = storageManager.getSenderBeanMgr();
        String seqID = SandeshaUtil.getUUID();
        RMSBean rmsBean = new RMSBean();
        rmsBean.setCreateSeqMsgID(SandeshaUtil.getUUID());
        rmsBean.setSequenceID(seqID);
        rmsBean.setInternalSequenceID(SandeshaUtil.getInternalSequenceID((String)seqID, null));
        rmsBean.setToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmsBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmsBean.setReplyToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmsBean.setRMVersion("Spec_2007_02");
        rmsBean.setClientCompletedMessages(new RangeString());
        rmsBean.setNextMessageNumber(4L);
        rmsBean.setHighestOutMessageNumber(3L);
        SenderBean bean1 = InvalidAcknowledgementTest.getSenderBean(seqID, 1, 1);
        SenderBean bean2 = InvalidAcknowledgementTest.getSenderBean(seqID, 0, 2);
        SenderBean bean3 = InvalidAcknowledgementTest.getSenderBean(seqID, 1, 3);
        Transaction tran = storageManager.getTransaction();
        rmsBeanMgr.insert(rmsBean);
        senderMgr.insert(bean1);
        senderMgr.insert(bean2);
        senderMgr.insert(bean3);
        tran.commit();
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement");
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getAppMessageAsBytes(seqID);
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        InvalidAcknowledgementTest.assertNotNull((Object)message);
        InvalidAcknowledgementTest.assertTrue((message.indexOf("wsrm:InvalidAcknowledgement") > -1 ? 1 : 0) != 0);
        String faultID = message.substring(message.indexOf("<wsrm:Identifier>") + 17, message.indexOf("</wsrm:Identifier>"));
        InvalidAcknowledgementTest.assertEquals((String)seqID, (String)faultID);
        connection.disconnect();
    }

    private byte[] getAppMessageAsBytes(String sequenceId) throws Exception {
        SOAP11Factory factory = new SOAP11Factory();
        SOAPEnvelope dummyEnvelope = factory.getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(this.serverConfigContext);
        messageContext.setAxisService(this.serverConfigContext.getAxisConfiguration().getService("RMSampleService"));
        messageContext.setEnvelope(dummyEnvelope);
        RMMsgContext applicationRMMsg = new RMMsgContext(messageContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue((String)"Spec_2007_02");
        SequenceAcknowledgement sequenceAck = new SequenceAcknowledgement(rmNamespaceValue);
        Identifier id = new Identifier(rmNamespaceValue);
        id.setIndentifer(sequenceId);
        sequenceAck.setIdentifier(id);
        AcknowledgementRange ackRange = new AcknowledgementRange(rmNamespaceValue);
        ackRange.setLowerValue(1L);
        ackRange.setUpperValue(3L);
        sequenceAck.addAcknowledgementRanges(ackRange);
        applicationRMMsg.setMessagePart(7, (IOMRMPart)sequenceAck);
        applicationRMMsg.addSOAPEnvelope();
        messageContext.setWSAAction("http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        applicationRMMsg.getMessageContext().getEnvelope().serialize((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private static SenderBean getSenderBean(String seqID, int sendCount, int messageNo) {
        SenderBean bean = new SenderBean();
        bean.setInternalSequenceID(SandeshaUtil.getInternalSequenceID((String)seqID, null));
        bean.setSequenceID(seqID);
        bean.setMessageID(SandeshaUtil.getUUID());
        bean.setSentCount(sendCount);
        bean.setSend(true);
        bean.setReSend(true);
        bean.setMessageType(3);
        bean.setMessageNumber((long)messageNo);
        return bean;
    }
}

