/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.faulttests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.faulttests.FaultTestUtils;
import org.apache.sandesha2.msgreceivers.RMMessageReceiver;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MessageNumber;
import org.apache.sandesha2.wsrm.Sequence;

public class SequenceTerminatedFaultTest
extends SandeshaTestCase {
    private static final String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    private static final String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
    private static ConfigurationContext serverConfigContext;
    private boolean serverStarted = false;

    public SequenceTerminatedFaultTest() {
        super("SequenceTerminatedFaultTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        if (!this.serverStarted) {
            serverConfigContext = this.startServer(server_repoPath, server_axis2_xml);
        }
        this.serverStarted = true;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSequenceTerminatedFault() throws Exception {
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", this.pingAction);
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)serverConfigContext, (AxisDescription)serverConfigContext.getAxisConfiguration());
        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
        String seqID = SandeshaUtil.getUUID();
        RMDBean rmdBean = new RMDBean();
        rmdBean.setSequenceID(seqID);
        rmdBean.setToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setReplyToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setRMVersion("Spec_2007_02");
        rmdBean.setServerCompletedMessages(new RangeString());
        rmdBean.setTerminated(true);
        Transaction tran = storageManager.getTransaction();
        rmdBeanMgr.insert(rmdBean);
        tran.commit();
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getAppMessageAsBytes(seqID);
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        SequenceTerminatedFaultTest.assertNotNull((Object)message);
        SequenceTerminatedFaultTest.assertTrue((message.indexOf("wsrm:SequenceTerminated") > -1 ? 1 : 0) != 0);
        String faultID = message.substring(message.indexOf("<wsrm:Identifier>") + 17, message.indexOf("</wsrm:Identifier>"));
        SequenceTerminatedFaultTest.assertEquals((String)seqID, (String)faultID);
        connection.disconnect();
    }

    public void testSequenceTerminatedOnCloseFault() throws Exception {
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", "http://docs.oasis-open.org/ws-rx/wsrm/200702/CloseSequence");
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)serverConfigContext, (AxisDescription)serverConfigContext.getAxisConfiguration());
        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
        String seqID = SandeshaUtil.getUUID();
        RMDBean rmdBean = new RMDBean();
        rmdBean.setSequenceID(seqID);
        rmdBean.setToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setReplyToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setRMVersion("Spec_2007_02");
        rmdBean.setServerCompletedMessages(new RangeString());
        rmdBean.setTerminated(true);
        Transaction tran = storageManager.getTransaction();
        rmdBeanMgr.insert(rmdBean);
        tran.commit();
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getCloseMessageAsBytes(seqID);
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        SequenceTerminatedFaultTest.assertNotNull((Object)message);
        SequenceTerminatedFaultTest.assertTrue((message.indexOf("wsrm:SequenceTerminated") > -1 ? 1 : 0) != 0);
        String faultID = message.substring(message.indexOf("<wsrm:Identifier>") + 17, message.indexOf("</wsrm:Identifier>"));
        SequenceTerminatedFaultTest.assertEquals((String)seqID, (String)faultID);
        connection.disconnect();
    }

    public void testSequenceTerminatedOnAckRequestFault() throws Exception {
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", "http://docs.oasis-open.org/ws-rx/wsrm/200702/AckRequested");
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)serverConfigContext, (AxisDescription)serverConfigContext.getAxisConfiguration());
        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
        String seqID = SandeshaUtil.getUUID();
        RMDBean rmdBean = new RMDBean();
        rmdBean.setSequenceID(seqID);
        rmdBean.setToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setReplyToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setRMVersion("Spec_2007_02");
        rmdBean.setServerCompletedMessages(new RangeString());
        rmdBean.setTerminated(true);
        Transaction tran = storageManager.getTransaction();
        rmdBeanMgr.insert(rmdBean);
        tran.commit();
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getAckRequestMessageAsBytes(seqID);
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        SequenceTerminatedFaultTest.assertNotNull((Object)message);
        SequenceTerminatedFaultTest.assertTrue((message.indexOf("wsrm:SequenceTerminated") > -1 ? 1 : 0) != 0);
        String faultID = message.substring(message.indexOf("<wsrm:Identifier>") + 17, message.indexOf("</wsrm:Identifier>"));
        SequenceTerminatedFaultTest.assertEquals((String)seqID, (String)faultID);
        connection.disconnect();
    }

    public void testRMSSequenceTerminatedOnSequenceTerminatedFault() throws Exception {
        this.runSequenceTerminated(false, false);
    }

    public void testRMSSequenceTerminatedOnSequenceTerminatedFaultSOAP12() throws Exception {
        this.runSequenceTerminated(false, true);
    }

    public void testRMSSequenceTerminatedOnSequenceUnknownFault() throws Exception {
        this.runSequenceTerminated(true, false);
    }

    public void testRMSSequenceTerminatedOnSequenceUnknownFaultSOAP12() throws Exception {
        this.runSequenceTerminated(true, true);
    }

    private void runSequenceTerminated(boolean deleteRMSBean, boolean soap12) throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setFaultTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        if (soap12) {
            clientOptions.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        }
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)serverConfigContext, (AxisDescription)serverConfigContext.getAxisConfiguration());
            Transaction tran = storageManager.getTransaction();
            RMDBean finderBean = new RMDBean();
            finderBean.setTerminated(false);
            List rmdBeans = storageManager.getRMDBeanMgr().find(finderBean);
            tran.commit();
            lastError = null;
            if (rmdBeans.isEmpty()) {
                lastError = new Error("rmdBeans empty " + rmdBeans);
                continue;
            }
            RMDBean bean = (RMDBean)rmdBeans.get(0);
            if (!bean.getServerCompletedMessages().getContainedElementsAsNumbersList().contains(new Integer(1))) {
                tran = storageManager.getTransaction();
                if (deleteRMSBean) {
                    storageManager.getRMDBeanMgr().delete(bean.getSequenceID());
                } else {
                    bean.setTerminated(true);
                    storageManager.getRMDBeanMgr().update(bean);
                }
                tran.commit();
                break;
            }
            lastError = new Error("App message has not arrived");
        }
        if (lastError != null) {
            throw lastError;
        }
        serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SequenceTerminatedFaultTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)3);
                SequenceTerminatedFaultTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    private byte[] getAppMessageAsBytes(String uuid) throws Exception {
        SOAP11Factory factory = new SOAP11Factory();
        SOAPEnvelope dummyEnvelope = factory.getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(serverConfigContext);
        messageContext.setAxisService(serverConfigContext.getAxisConfiguration().getService("RMSampleService"));
        messageContext.setEnvelope(dummyEnvelope);
        RMMsgContext applicationRMMsg = new RMMsgContext(messageContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue((String)"Spec_2007_02");
        Sequence sequence = new Sequence(rmNamespaceValue);
        MessageNumber msgNumber = new MessageNumber(rmNamespaceValue);
        msgNumber.setMessageNumber(1L);
        sequence.setMessageNumber(msgNumber);
        Identifier id1 = new Identifier(rmNamespaceValue);
        id1.setIndentifer(uuid);
        sequence.setIdentifier(id1);
        applicationRMMsg.setMessagePart(6, (IOMRMPart)sequence);
        applicationRMMsg.addSOAPEnvelope();
        messageContext.setWSAAction(this.pingAction);
        AxisOperation operation = messageContext.getAxisService().getOperation(Sandesha2Constants.RM_IN_OUT_OPERATION);
        operation.setMessageReceiver((MessageReceiver)new RMMessageReceiver());
        messageContext.setAxisOperation(operation);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        applicationRMMsg.getMessageContext().getEnvelope().serialize((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private byte[] getCloseMessageAsBytes(String uuid) throws Exception {
        SOAP11Factory factory = new SOAP11Factory();
        SOAPEnvelope dummyEnvelope = factory.getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(serverConfigContext);
        messageContext.setAxisService(serverConfigContext.getAxisConfiguration().getService("RMSampleService"));
        messageContext.setEnvelope(dummyEnvelope);
        RMMsgContext applicationRMMsg = new RMMsgContext(messageContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue((String)"Spec_2007_02");
        CloseSequence sequence = new CloseSequence(rmNamespaceValue);
        Identifier id1 = new Identifier(rmNamespaceValue);
        id1.setIndentifer(uuid);
        sequence.setIdentifier(id1);
        applicationRMMsg.setMessagePart(12, (IOMRMPart)sequence);
        applicationRMMsg.addSOAPEnvelope();
        messageContext.setWSAAction(this.pingAction);
        AxisOperation operation = messageContext.getAxisService().getOperation(Sandesha2Constants.RM_IN_OUT_OPERATION);
        operation.setMessageReceiver((MessageReceiver)new RMMessageReceiver());
        messageContext.setAxisOperation(operation);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        applicationRMMsg.getMessageContext().getEnvelope().serialize((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private byte[] getAckRequestMessageAsBytes(String uuid) throws Exception {
        SOAP11Factory factory = new SOAP11Factory();
        SOAPEnvelope dummyEnvelope = factory.getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(serverConfigContext);
        messageContext.setAxisService(serverConfigContext.getAxisConfiguration().getService("RMSampleService"));
        messageContext.setEnvelope(dummyEnvelope);
        RMMsgContext applicationRMMsg = new RMMsgContext(messageContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue((String)"Spec_2007_02");
        AckRequested sequence = new AckRequested(rmNamespaceValue);
        Identifier id1 = new Identifier(rmNamespaceValue);
        id1.setIndentifer(uuid);
        sequence.setIdentifier(id1);
        applicationRMMsg.setMessagePart(12, (IOMRMPart)sequence);
        applicationRMMsg.addSOAPEnvelope();
        messageContext.setWSAAction(this.pingAction);
        AxisOperation operation = messageContext.getAxisService().getOperation(Sandesha2Constants.RM_IN_OUT_OPERATION);
        operation.setMessageReceiver((MessageReceiver)new RMMessageReceiver());
        messageContext.setAxisOperation(operation);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        applicationRMMsg.getMessageContext().getEnvelope().serialize((OutputStream)outputStream);
        return outputStream.toByteArray();
    }
}

