/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.scenarios;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.util.SandeshaUtil;

public class RMScenariosTest
extends SandeshaTestCase {
    private boolean serverStarted = false;
    protected ConfigurationContext configContext = null;
    protected String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
    protected String repoPath = "target" + File.separator + "repos" + File.separator + "server";
    protected String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
    protected String repoPathClient = "target" + File.separator + "repos" + File.separator + "client";
    protected String axis2_xmlClient = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";

    public RMScenariosTest() {
        super("RMScenariosTest");
    }

    public RMScenariosTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        if (!this.serverStarted) {
            this.startServer(this.repoPath, this.axis2_xml);
            this.configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repoPathClient, (String)this.axis2_xmlClient);
        }
        this.serverStarted = true;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPing() throws Exception {
        this.runPing(false, false);
        this.runPing(true, true);
    }

    public void testAsyncEcho() throws Exception {
        Options clientOptions = new Options();
        this.runEcho(clientOptions, true, false, false, true, false);
        clientOptions = new Options();
        this.runEcho(clientOptions, true, true, false, true, false);
        clientOptions = new Options();
        clientOptions.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)SandeshaUtil.getUUID());
        this.runEcho(clientOptions, true, true, false, true, true);
    }

    public void testSyncEcho() throws Exception {
        Options clientOptions = new Options();
        clientOptions.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)SandeshaUtil.getUUID());
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        this.runEcho(clientOptions, false, false, true, true, false);
        clientOptions = new Options();
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        this.runEcho(clientOptions, false, false, true, true, true);
    }

    public void runPing(boolean asyncAcks, boolean stopListener) throws Exception {
        Options clientOptions = new Options();
        ServiceClient serviceClient = new ServiceClient(this.configContext, null);
        serviceClient.setOptions(clientOptions);
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setAction(this.pingAction);
        clientOptions.setTo(new EndpointReference(this.to));
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        if (asyncAcks) {
            String acksTo = serviceClient.getMyEPR("http").getAddress();
            clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
            clientOptions.setTransportInProtocol("http");
            clientOptions.setUseSeparateListener(true);
        }
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                RMScenariosTest.assertTrue((String)"Checking completed messages", (boolean)sequenceReport.getCompletedMessages().contains(new Long(1L)));
                RMScenariosTest.assertEquals((String)"Checking sequence terminated", (byte)3, (byte)sequenceReport.getSequenceStatus());
                RMScenariosTest.assertEquals((String)"Checking sequence direction", (byte)2, (byte)sequenceReport.getSequenceDirection());
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        if (stopListener) {
            this.configContext.getListenerManager().stop();
        }
        serviceClient.cleanup();
    }

    public void runEcho(Options clientOptions, boolean asyncReply, boolean asyncAcks, boolean explicitTermination, boolean checkInboundTermination, boolean stopListener) throws Exception {
        String acksTo;
        String sequenceKey = SandeshaUtil.getUUID();
        ServiceClient serviceClient = new ServiceClient(this.configContext, null);
        serviceClient.setOptions(clientOptions);
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(this.to));
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        clientOptions.setTransportInProtocol("http");
        if (asyncReply || asyncAcks) {
            clientOptions.setUseSeparateListener(true);
            if (asyncAcks) {
                acksTo = serviceClient.getMyEPR("http").getAddress();
                clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
            } else {
                acksTo = "http://www.w3.org/2005/08/addressing/anonymous";
                clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
            }
        }
        if (asyncAcks) {
            acksTo = serviceClient.getMyEPR("http").getAddress();
            clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        } else {
            acksTo = "http://www.w3.org/2005/08/addressing/anonymous";
            clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        }
        List oldIncomingReports = SandeshaClient.getIncomingSequenceReports((ConfigurationContext)this.configContext);
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback(this, "Callback 1");
        serviceClient.sendReceiveNonBlocking(RMScenariosTest.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        SandeshaTestCase.TestCallback callback2 = new SandeshaTestCase.TestCallback(this, "Callback 2");
        serviceClient.sendReceiveNonBlocking(RMScenariosTest.getEchoOMBlock("echo2", sequenceKey), (AxisCallback)callback2);
        if (!explicitTermination && !"Spec_2007_02".equals(clientOptions.getProperty(SandeshaClientConstants.RM_SPEC_VERSION))) {
            clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        }
        SandeshaTestCase.TestCallback callback3 = new SandeshaTestCase.TestCallback(this, "Callback 3");
        serviceClient.sendReceiveNonBlocking(RMScenariosTest.getEchoOMBlock("echo3", sequenceKey), (AxisCallback)callback3);
        if (explicitTermination) {
            Thread.sleep(10000L);
            SandeshaClient.terminateSequence((ServiceClient)serviceClient);
        }
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport outgoingSequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                RMScenariosTest.assertTrue((String)"Outbound message #1", (boolean)outgoingSequenceReport.getCompletedMessages().contains(new Long(1L)));
                RMScenariosTest.assertTrue((String)"Outbound message #2", (boolean)outgoingSequenceReport.getCompletedMessages().contains(new Long(2L)));
                RMScenariosTest.assertTrue((String)"Outbound message #3", (boolean)outgoingSequenceReport.getCompletedMessages().contains(new Long(3L)));
                RMScenariosTest.assertEquals((String)"Outbound sequence status: TERMINATED", (byte)3, (byte)outgoingSequenceReport.getSequenceStatus());
                RMScenariosTest.assertEquals((String)"Outbound sequence direction: OUT", (byte)2, (byte)outgoingSequenceReport.getSequenceDirection());
                List incomingSequences = SandeshaClient.getIncomingSequenceReports((ConfigurationContext)this.configContext);
                SequenceReport incomingSequenceReport = this.getNewReport(incomingSequences, oldIncomingReports);
                String offer = (String)clientOptions.getProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID);
                if (offer != null) {
                    RMScenariosTest.assertEquals((String)"Inbound seq id", (String)offer, (String)incomingSequenceReport.getSequenceID());
                }
                RMScenariosTest.assertEquals((String)"Inbound message count", (int)3, (int)incomingSequenceReport.getCompletedMessages().size());
                RMScenariosTest.assertTrue((String)"Inbound message #1", (boolean)incomingSequenceReport.getCompletedMessages().contains(new Long(1L)));
                RMScenariosTest.assertTrue((String)"Inbound message #2", (boolean)incomingSequenceReport.getCompletedMessages().contains(new Long(2L)));
                RMScenariosTest.assertTrue((String)"Inbound message #3", (boolean)incomingSequenceReport.getCompletedMessages().contains(new Long(3L)));
                if (checkInboundTermination) {
                    RMScenariosTest.assertEquals((String)"Inbound sequence status: TERMINATED", (byte)3, (byte)incomingSequenceReport.getSequenceStatus());
                }
                RMScenariosTest.assertEquals((String)"Inbound sequence direction: IN", (byte)1, (byte)incomingSequenceReport.getSequenceDirection());
                RMScenariosTest.assertTrue((String)"Callback #1", (boolean)callback1.isComplete());
                RMScenariosTest.assertEquals((String)"Callback #1 data", (String)"echo1", (String)callback1.getResult());
                RMScenariosTest.assertTrue((String)"Callback #2", (boolean)callback2.isComplete());
                RMScenariosTest.assertEquals((String)"Callback #2 data", (String)"echo1echo2", (String)callback2.getResult());
                RMScenariosTest.assertTrue((String)"Callback #3", (boolean)callback3.isComplete());
                RMScenariosTest.assertEquals((String)"Callback #3 data", (String)"echo1echo2echo3", (String)callback3.getResult());
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        if (stopListener) {
            this.configContext.getListenerManager().stop();
        }
        serviceClient.cleanup();
    }

    private SequenceReport getNewReport(List incomingSequences, List oldIncomingReports) {
        SequenceReport report;
        HashSet<String> sequenceIds = new HashSet<String>();
        Iterator oldSequences = oldIncomingReports.iterator();
        while (oldSequences.hasNext()) {
            report = (SequenceReport)oldSequences.next();
            sequenceIds.add(report.getSequenceID());
        }
        Iterator currentSequences = incomingSequences.iterator();
        while (currentSequences.hasNext()) {
            report = (SequenceReport)currentSequences.next();
            if (sequenceIds.contains(report.getSequenceID())) continue;
            return report;
        }
        throw new AssertionFailedError("Failed to find a new reply sequence");
    }
}

