/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.security;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.security.UnitTestSecurityToken;

public class UnitTestSecurityManager
extends SecurityManager {
    private static Log log = LogFactory.getLog((Class)UnitTestSecurityManager.class);
    private static HashMap tokens = new HashMap();
    private static int id = 0;
    private static String secNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static QName unitTestHeader = new QName("http://unit.test.security", "tokenId");

    public UnitTestSecurityManager(ConfigurationContext context) {
        super(context);
        log.debug((Object)"UnitTestSecurityManager::UnitTestSecurityManager");
    }

    public void initSecurity(AxisModule moduleDesc) {
        log.debug((Object)"UnitTestSecurityManager::initSecurity");
    }

    public SecurityToken getSecurityToken(MessageContext message) {
        log.debug((Object)"Enter: UnitTestSecurityManager::getSecurityToken(MessageContext)");
        UnitTestSecurityToken result = new UnitTestSecurityToken(id++);
        tokens.put(this.getTokenRecoveryData(result), result);
        log.debug((Object)("Exit: UnitTestSecurityManager::getSecurityToken " + result));
        return result;
    }

    public SecurityToken getSecurityToken(OMElement theSTR, MessageContext message) {
        String securityTokenURI;
        log.debug((Object)"Enter: UnitTestSecurityManager::getSecurityToken(OMElement,MessageContext)");
        OMElement reference = theSTR.getFirstChildWithName(new QName(secNamespace, "Reference"));
        String key = securityTokenURI = reference.getAttributeValue(new QName("URI"));
        SecurityToken result = (SecurityToken)tokens.get(key);
        log.debug((Object)("Exit: UnitTestSecurityManager::getSecurityToken " + result));
        return result;
    }

    public String getTokenRecoveryData(SecurityToken token) {
        log.debug((Object)"Enter: UnitTestSecurityManager::getTokenRecoveryData");
        String key = ((UnitTestSecurityToken)token).getURI();
        log.debug((Object)("Exit: UnitTestSecurityManager::getTokenRecoveryData " + key));
        return key;
    }

    public SecurityToken recoverSecurityToken(String tokenData) {
        log.debug((Object)"Enter: UnitTestSecurityManager::recoverSecurityToken");
        SecurityToken result = (SecurityToken)tokens.get(tokenData);
        log.debug((Object)("Exit: UnitTestSecurityManager::recoverSecurityToken " + result));
        return result;
    }

    public void checkProofOfPossession(SecurityToken token, OMElement messagePart, MessageContext message) throws SandeshaException {
        log.debug((Object)"Enter: UnitTestSecurityManager::checkProofOfPossession");
        if (token == null) {
            throw new SandeshaException("Security manager was passed a null token");
        }
        String key = ((UnitTestSecurityToken)token).getURI();
        boolean foundToken = false;
        SOAPEnvelope env = message.getEnvelope();
        SOAPHeader headers = env.getHeader();
        if (headers != null) {
            Iterator tokens = headers.getChildrenWithName(unitTestHeader);
            while (tokens.hasNext()) {
                OMElement myHeader = (OMElement)tokens.next();
                String text = myHeader.getText();
                if (!key.equals(text)) continue;
                foundToken = true;
                break;
            }
        }
        if (!foundToken) {
            SandeshaException e = new SandeshaException("Message was not secured with the correct token(s)");
            e.printStackTrace(System.err);
            throw e;
        }
        log.debug((Object)"Exit: UnitTestSecurityManager::checkProofOfPossession");
    }

    public OMElement createSecurityTokenReference(SecurityToken token, MessageContext message) {
        log.debug((Object)"Enter: UnitTestSecurityManager::createSecurityTokenReference");
        String uri = ((UnitTestSecurityToken)token).getURI();
        String type = ((UnitTestSecurityToken)token).getValueType();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace secNS = factory.createOMNamespace(secNamespace, "wsse");
        OMElement str = factory.createOMElement("SecurityTokenReference", secNS);
        OMElement ref = factory.createOMElement("Reference", secNS);
        str.addChild((OMNode)ref);
        OMAttribute uriAttr = factory.createOMAttribute("URI", null, uri);
        OMAttribute typeAttr = factory.createOMAttribute("ValueType", null, type);
        ref.addAttribute(uriAttr);
        ref.addAttribute(typeAttr);
        log.debug((Object)("Exit: UnitTestSecurityManager::createSecurityTokenReference " + str));
        return str;
    }

    public void applySecurityToken(SecurityToken token, MessageContext outboundMessage) throws SandeshaException {
        log.debug((Object)"Enter: UnitTestSecurityManager::applySecurityToken");
        if (token == null) {
            throw new SandeshaException("Security manager was passed a null token");
        }
        String key = ((UnitTestSecurityToken)token).getURI();
        SOAPEnvelope env = outboundMessage.getEnvelope();
        OMFactory factory = env.getOMFactory();
        SOAPHeader headers = env.getHeader();
        OMNamespace namespace = factory.createOMNamespace(unitTestHeader.getNamespaceURI(), "sec");
        SOAPHeaderBlock header = headers.addHeaderBlock(unitTestHeader.getLocalPart(), namespace);
        header.setText(key);
        log.debug((Object)"Exit: UnitTestSecurityManager::applySecurityToken");
    }
}

