/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage;

import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class InvokerBeanMgrTest
extends SandeshaTestCase {
    InvokerBeanMgr mgr;
    Transaction transaction;

    public InvokerBeanMgrTest() {
        super("InvokerBeanMgrTest");
    }

    public void setUp() throws Exception {
        AxisConfiguration axisConfig = new AxisConfiguration();
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Parameter parameter = new Parameter();
        parameter.setName("Sandesha2PropertyBean");
        parameter.setValue((Object)propertyBean);
        axisConfig.addParameter(parameter);
        ConfigurationContext configCtx = new ConfigurationContext(axisConfig);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        parameter = new Parameter("Sandesha2ModuleClassLoader", (Object)classLoader);
        axisConfig.addParameter(parameter);
        StorageManager storageManager = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)configCtx);
        this.transaction = storageManager.getTransaction();
        this.mgr = storageManager.getInvokerBeanMgr();
    }

    public void tearDown() throws Exception {
        this.transaction.commit();
    }

    public void testDelete() throws SandeshaStorageException {
        this.mgr.insert(new InvokerBean("Key1", 1001L, "SeqId1"));
        this.mgr.delete("Key1");
        InvokerBeanMgrTest.assertNull((Object)this.mgr.retrieve("Key1"));
    }

    public void testFind() throws SandeshaStorageException {
        this.mgr.insert(new InvokerBean("Key2", 1002L, "SeqId2"));
        this.mgr.insert(new InvokerBean("Key3", 1003L, "SeqId2"));
        InvokerBean bean = new InvokerBean();
        bean.setSequenceID("SeqId2");
        Iterator iter = this.mgr.find(bean).iterator();
        InvokerBean tmp = (InvokerBean)iter.next();
        if (tmp.getMessageContextRefKey().equals("Key2")) {
            tmp = (InvokerBean)iter.next();
            InvokerBeanMgrTest.assertTrue((boolean)tmp.getMessageContextRefKey().equals("Key3"));
        } else {
            tmp = (InvokerBean)iter.next();
            InvokerBeanMgrTest.assertTrue((boolean)tmp.getMessageContextRefKey().equals("Key2"));
        }
    }

    public void testInsert() throws SandeshaStorageException {
        this.mgr.insert(new InvokerBean("Key4", 1004L, "SeqId4"));
        InvokerBean tmp = this.mgr.retrieve("Key4");
        InvokerBeanMgrTest.assertTrue((boolean)tmp.getMessageContextRefKey().equals("Key4"));
    }

    public void testRetrieve() throws SandeshaStorageException {
        InvokerBeanMgrTest.assertNull((Object)this.mgr.retrieve("Key5"));
        this.mgr.insert(new InvokerBean("Key5", 1004L, "SeqId5"));
        InvokerBeanMgrTest.assertNotNull((Object)this.mgr.retrieve("Key5"));
    }

    public void testUpdate() throws SandeshaStorageException {
        InvokerBean bean = new InvokerBean("Key6", 1006L, "SeqId6");
        this.mgr.insert(bean);
        bean.setMsgNo(1007L);
        this.mgr.update(bean);
        InvokerBean tmp = this.mgr.retrieve("Key6");
        InvokerBeanMgrTest.assertTrue((tmp.getMsgNo() == 1007L ? 1 : 0) != 0);
    }
}

