/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage;

import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class RMDBeanMgrTest
extends SandeshaTestCase {
    private RMDBeanMgr mgr;
    Transaction transaction;

    public RMDBeanMgrTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        AxisConfiguration axisConfig = new AxisConfiguration();
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Parameter parameter = new Parameter();
        parameter.setName("Sandesha2PropertyBean");
        parameter.setValue((Object)propertyBean);
        axisConfig.addParameter(parameter);
        ConfigurationContext configCtx = new ConfigurationContext(axisConfig);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        parameter = new Parameter("Sandesha2ModuleClassLoader", (Object)classLoader);
        axisConfig.addParameter(parameter);
        StorageManager storageManager = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)configCtx);
        this.transaction = storageManager.getTransaction();
        this.mgr = storageManager.getRMDBeanMgr();
    }

    public void tearDown() throws Exception {
        this.transaction.commit();
    }

    public void testDelete() throws SandeshaStorageException {
        this.mgr.insert(new RMDBean("SeqId1", 1001L));
        this.mgr.delete("SeqId1");
        RMDBeanMgrTest.assertNull((Object)this.mgr.retrieve("SeqId1"));
    }

    public void testFind() throws SandeshaStorageException {
        this.mgr.insert(new RMDBean("SeqId2", 1002L));
        this.mgr.insert(new RMDBean("SeqId3", 1002L));
        RMDBean target = new RMDBean();
        target.setNextMsgNoToProcess(1002L);
        Iterator iterator = this.mgr.find(target).iterator();
        RMDBean tmp = (RMDBean)iterator.next();
        if (tmp.getSequenceID().equals("SeqId2")) {
            tmp = (RMDBean)iterator.next();
            tmp.getSequenceID().equals("SeqId3");
        } else {
            tmp = (RMDBean)iterator.next();
            tmp.getSequenceID().equals("SeqId2");
        }
    }

    public void testInsert() throws SandeshaStorageException {
        RMDBean bean = new RMDBean("SeqId4", 1004L);
        this.mgr.insert(bean);
        RMDBean tmp = this.mgr.retrieve("SeqId4");
        RMDBeanMgrTest.assertTrue((tmp.getNextMsgNoToProcess() == 1004L ? 1 : 0) != 0);
    }

    public void testRetrieve() throws SandeshaStorageException {
        RMDBeanMgrTest.assertNull((Object)this.mgr.retrieve("SeqId5"));
        this.mgr.insert(new RMDBean("SeqId5", 1005L));
        RMDBean tmp = this.mgr.retrieve("SeqId5");
        RMDBeanMgrTest.assertTrue((tmp.getNextMsgNoToProcess() == 1005L ? 1 : 0) != 0);
    }

    public void testUpdate() throws SandeshaStorageException {
        RMDBean bean = new RMDBean("SeqId6", 1006L);
        this.mgr.insert(bean);
        bean.setNextMsgNoToProcess(1007L);
        this.mgr.update(bean);
        RMDBean tmp = this.mgr.retrieve("SeqId6");
        RMDBeanMgrTest.assertTrue((tmp.getNextMsgNoToProcess() == 1007L ? 1 : 0) != 0);
    }
}

