/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage;

import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class RMSBeanMgrTest
extends SandeshaTestCase {
    private RMSBeanMgr mgr;
    Transaction transaction;

    public RMSBeanMgrTest() {
        super("RMSBeanMgrTest");
    }

    public void setUp() throws Exception {
        AxisConfiguration axisConfig = new AxisConfiguration();
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Parameter parameter = new Parameter();
        parameter.setName("Sandesha2PropertyBean");
        parameter.setValue((Object)propertyBean);
        axisConfig.addParameter(parameter);
        ConfigurationContext configCtx = new ConfigurationContext(axisConfig);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        parameter = new Parameter("Sandesha2ModuleClassLoader", (Object)classLoader);
        axisConfig.addParameter(parameter);
        StorageManager storageManager = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)configCtx);
        this.transaction = storageManager.getTransaction();
        this.mgr = storageManager.getRMSBeanMgr();
    }

    public void tearDown() throws Exception {
        this.transaction.commit();
    }

    public void testDelete() throws SandeshaStorageException {
        RMSBean rMSBean = new RMSBean();
        rMSBean.setInternalSequenceID("TmpSeqId1");
        rMSBean.setCreateSeqMsgID("CreateSeqMsgId1");
        rMSBean.setSequenceID("SeqId1");
        this.mgr.insert(rMSBean);
        this.mgr.delete("CreateSeqMsgId1");
        RMSBeanMgrTest.assertNull((Object)this.mgr.retrieve("CreateSeqMsgId1"));
    }

    public void testFind() throws SandeshaStorageException {
        RMSBean createSeqBean1 = new RMSBean();
        createSeqBean1.setInternalSequenceID("TmpSeqId1");
        createSeqBean1.setCreateSeqMsgID("CreateSeqMsgId1");
        createSeqBean1.setSequenceID("SeqId1");
        RMSBean createSeqBean2 = new RMSBean();
        createSeqBean2.setInternalSequenceID("TmpSeqId1");
        createSeqBean2.setCreateSeqMsgID("CreateSeqMsgId2");
        createSeqBean2.setSequenceID("SeqId2");
        this.mgr.insert(createSeqBean1);
        this.mgr.insert(createSeqBean2);
        RMSBean target = new RMSBean();
        target.setInternalSequenceID("TmpSeqId1");
        Iterator iter = this.mgr.find(target).iterator();
        RMSBean tmp = (RMSBean)iter.next();
        if (tmp.getCreateSeqMsgID().equals("CreateSeqMsgId1")) {
            tmp = (RMSBean)iter.next();
            RMSBeanMgrTest.assertTrue((boolean)tmp.getCreateSeqMsgID().equals("CreateSeqMsgId2"));
        } else {
            tmp = (RMSBean)iter.next();
            RMSBeanMgrTest.assertTrue((boolean)tmp.getCreateSeqMsgID().equals("CreateSeqMsgId1"));
        }
    }

    public void testInsert() throws SandeshaStorageException {
        RMSBean rMSBean = new RMSBean();
        rMSBean.setInternalSequenceID("TmpSeqId4");
        rMSBean.setCreateSeqMsgID("CreateSeqMsgId4");
        rMSBean.setSequenceID("SeqId4");
        this.mgr.insert(rMSBean);
        RMSBean tmpbean = this.mgr.retrieve("CreateSeqMsgId4");
        RMSBeanMgrTest.assertTrue((boolean)tmpbean.getCreateSeqMsgID().equals("CreateSeqMsgId4"));
        RMSBeanMgrTest.assertTrue((boolean)tmpbean.getSequenceID().equals("SeqId4"));
        RMSBeanMgrTest.assertTrue((boolean)tmpbean.getInternalSequenceID().equals("TmpSeqId4"));
    }

    public void testRetrieve() throws SandeshaStorageException {
        RMSBeanMgrTest.assertNull((Object)this.mgr.retrieve("CreateSeqMsgId5"));
        RMSBean rMSBean = new RMSBean();
        rMSBean.setInternalSequenceID("TmpSeqId5");
        rMSBean.setCreateSeqMsgID("CreateSeqMsgId5");
        rMSBean.setSequenceID("SeqId5");
        this.mgr.insert(rMSBean);
        RMSBean tmp = this.mgr.retrieve("CreateSeqMsgId5");
        RMSBeanMgrTest.assertTrue((boolean)tmp.getCreateSeqMsgID().equals("CreateSeqMsgId5"));
    }

    public void testUpdate() throws SandeshaStorageException {
        RMSBean rMSBean = new RMSBean();
        rMSBean.setInternalSequenceID("TmpSeqId6");
        rMSBean.setCreateSeqMsgID("CreateSeqMsgId6");
        rMSBean.setSequenceID("SeqId6");
        this.mgr.insert(rMSBean);
        rMSBean.setInternalSequenceID("TmpSeqId7");
        this.mgr.update(rMSBean);
        RMSBean tmp = this.mgr.retrieve("CreateSeqMsgId6");
        RMSBeanMgrTest.assertTrue((boolean)tmp.getInternalSequenceID().equals("TmpSeqId7"));
    }
}

