/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage;

import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class SenderBeanMgrTest
extends SandeshaTestCase {
    private SenderBeanMgr mgr;
    Transaction transaction;

    public SenderBeanMgrTest() {
        super("SenderBeanMgrTest");
    }

    public void setUp() throws Exception {
        AxisConfiguration axisConfig = new AxisConfiguration();
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Parameter parameter = new Parameter();
        parameter.setName("Sandesha2PropertyBean");
        parameter.setValue((Object)propertyBean);
        axisConfig.addParameter(parameter);
        ConfigurationContext configCtx = new ConfigurationContext(axisConfig);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        parameter = new Parameter("Sandesha2ModuleClassLoader", (Object)classLoader);
        axisConfig.addParameter(parameter);
        StorageManager storageManager = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)configCtx);
        this.transaction = storageManager.getTransaction();
        this.mgr = storageManager.getSenderBeanMgr();
    }

    public void tearDown() throws Exception {
        this.transaction.commit();
    }

    public void testDelete() throws SandeshaStorageException {
        SenderBeanMgrTest.assertNull((Object)this.mgr.retrieve(""));
        try {
            this.mgr.insert(new SenderBean("MsgId1", "Key1", false, 1001L, "TmpSeqId1", 1001L));
        }
        catch (Exception ex) {
            SenderBeanMgrTest.fail((String)"should not throw an exception");
        }
        SenderBeanMgrTest.assertNotNull((Object)this.mgr.retrieve("MsgId1"));
    }

    public void testFind() {
        try {
            this.mgr.insert(new SenderBean("MsgId2", "Key2", false, 1001L, "TmpSeqId2", 1002L));
            this.mgr.insert(new SenderBean("MsgId3", "Key3", false, 1001L, "TmpSeqId2", 1003L));
            SenderBean target = new SenderBean();
            target.setInternalSequenceID("TmpSeqId2");
            Iterator iterator = this.mgr.find(target).iterator();
            SenderBean tmp = (SenderBean)iterator.next();
            if (tmp.getMessageID().equals("MsgId2")) {
                tmp = (SenderBean)iterator.next();
                SenderBeanMgrTest.assertTrue((boolean)tmp.getMessageID().equals("MsgId3"));
            } else {
                tmp = (SenderBean)iterator.next();
                SenderBeanMgrTest.assertTrue((boolean)tmp.getMessageID().equals("MsgId2"));
            }
        }
        catch (SandeshaException e) {
            SenderBeanMgrTest.fail((String)"should not throw an exception");
        }
    }

    public void testInsert() {
        try {
            this.mgr.insert(new SenderBean("MsgId4", "Key4", false, 1001L, "TmpSeqId4", 1004L));
            SenderBean tmp = this.mgr.retrieve("MsgId4");
            SenderBeanMgrTest.assertTrue((boolean)tmp.getMessageContextRefKey().equals("Key4"));
        }
        catch (SandeshaException e) {
            SenderBeanMgrTest.fail((String)"should not throw an exception");
        }
    }

    public void testRetrieve() throws SandeshaStorageException {
        SenderBeanMgrTest.assertNull((Object)this.mgr.retrieve("MsgId5"));
        try {
            this.mgr.insert(new SenderBean("MsgId5", "Key5", false, 1001L, "TmpSeqId5", 1005L));
        }
        catch (SandeshaException e) {
            SenderBeanMgrTest.fail((String)"this should not throw an exception");
        }
        SenderBeanMgrTest.assertNotNull((Object)this.mgr.retrieve("MsgId5"));
    }

    public void testUpdate() throws SandeshaStorageException {
        SenderBean bean = new SenderBean("MsgId6", "Key6", false, 1001L, "TmpSeqId6", 1006L);
        try {
            this.mgr.insert(bean);
        }
        catch (SandeshaException e) {
            SenderBeanMgrTest.fail((String)"should not throw an exception");
        }
        bean.setSend(true);
        this.mgr.update(bean);
        SenderBean tmp = this.mgr.retrieve("MsgId6");
        SenderBeanMgrTest.assertTrue((boolean)tmp.isSend());
    }
}

