/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;

public class RangeStringTest
extends SandeshaTestCase {
    public RangeStringTest(String s) {
        super(s);
    }

    public void testStringToRangeAndBack() {
        String finalRangeString = "[0,5][7,8][12,12]";
        RangeString rString = new RangeString(finalRangeString);
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(0L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(1L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(2L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(3L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(4L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(5L));
        RangeStringTest.assertFalse((boolean)rString.isMessageNumberInRanges(6L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(7L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(8L));
        RangeStringTest.assertFalse((boolean)rString.isMessageNumberInRanges(9L));
        RangeStringTest.assertFalse((boolean)rString.isMessageNumberInRanges(10L));
        RangeStringTest.assertFalse((boolean)rString.isMessageNumberInRanges(11L));
        RangeStringTest.assertTrue((boolean)rString.isMessageNumberInRanges(12L));
        RangeStringTest.assertFalse((boolean)rString.isMessageNumberInRanges(13L));
        RangeStringTest.assertFalse((boolean)rString.isMessageNumberInRanges(-1L));
        RangeStringTest.assertEquals((String)finalRangeString, (String)rString.toString());
    }

    public void testGrowingRange() {
        String msgs = "[1,1][10,10]";
        RangeString rString = new RangeString(msgs);
        Range ackedMsgRange = new Range(1L, 2L);
        Range[] newRanges = rString.addRange(ackedMsgRange).getRanges();
        RangeStringTest.assertEquals((int)newRanges.length, (int)1);
        RangeStringTest.assertEquals((Object)newRanges[0], (Object)new Range(2L, 2L));
        ackedMsgRange = new Range(8L, 9L);
        newRanges = rString.addRange(ackedMsgRange).getRanges();
        RangeStringTest.assertEquals((int)newRanges.length, (int)1);
        RangeStringTest.assertEquals((Object)newRanges[0], (Object)ackedMsgRange);
        ackedMsgRange = new Range(6L, 6L);
        newRanges = rString.addRange(ackedMsgRange).getRanges();
        RangeStringTest.assertEquals((int)newRanges.length, (int)1);
        RangeStringTest.assertEquals((Object)newRanges[0], (Object)ackedMsgRange);
        ackedMsgRange = new Range(1L, 5L);
        newRanges = rString.addRange(ackedMsgRange).getRanges();
        RangeStringTest.assertEquals((int)newRanges.length, (int)1);
        RangeStringTest.assertEquals((Object)newRanges[0], (Object)new Range(3L, 5L));
        ackedMsgRange = new Range(3L, 4L);
        newRanges = rString.addRange(ackedMsgRange).getRanges();
        RangeStringTest.assertEquals((int)newRanges.length, (int)0);
        ackedMsgRange = new Range(7L, 7L);
        newRanges = rString.addRange(ackedMsgRange).getRanges();
        RangeStringTest.assertEquals((int)newRanges.length, (int)1);
        RangeStringTest.assertEquals((Object)newRanges[0], (Object)ackedMsgRange);
        RangeStringTest.assertEquals((String)"[1,10]", (String)rString.toString());
        RangeStringTest.assertEquals((int)rString.addRange(new Range(1L, 10L)).getRanges().length, (int)0);
        RangeStringTest.assertEquals((String)"[1,10]", (String)rString.toString());
    }

    public void testSerialize() throws Exception {
        String msgRange = "[1,100]";
        RangeString r = new RangeString(msgRange);
        ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
        ObjectOutputStream serializer = new ObjectOutputStream(memoryBuffer);
        serializer.writeObject(r);
        serializer.flush();
        ObjectInputStream inStrm = new ObjectInputStream(new ByteArrayInputStream(memoryBuffer.toByteArray()));
        RangeString newRangeString = (RangeString)inStrm.readObject();
        RangeStringTest.assertEquals((String)msgRange, (String)newRangeString.toString());
    }
}

