/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.SequenceOffer;

public class CreateSequenceTest
extends SandeshaTestCase {
    SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
    String rmNamespaceValue = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    String addressingNamespaceValue = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    public CreateSequenceTest() {
        super("CreateSequenceTest");
    }

    public void testfromOMElement() throws AxisFault {
        CreateSequence createSequence = new CreateSequence(this.rmNamespaceValue);
        createSequence.fromOMElement((OMElement)this.getSOAPEnvelope("", "CreateSequence.xml").getBody());
        AcksTo acksTo = createSequence.getAcksTo();
        CreateSequenceTest.assertEquals((String)"http://127.0.0.1:9090/axis/services/RMService", (String)acksTo.getEPR().getAddress());
        SequenceOffer offer = createSequence.getSequenceOffer();
        Identifier identifier = offer.getIdentifer();
        CreateSequenceTest.assertEquals((String)"uuid:c3671020-15e0-11da-9b3b-f0439d4867bd", (String)identifier.getIdentifier());
    }

    public void testToSOAPEnvelope() throws AxisFault {
        CreateSequence createSequence = new CreateSequence(this.rmNamespaceValue);
        EndpointReference epr = new EndpointReference("http://127.0.0.1:9090/axis/services/RMService");
        AcksTo acksTo = new AcksTo(epr, this.rmNamespaceValue, this.addressingNamespaceValue);
        createSequence.setAcksTo(acksTo);
        SequenceOffer sequenceOffer = new SequenceOffer(this.rmNamespaceValue);
        Identifier identifier = new Identifier(this.rmNamespaceValue);
        identifier.setIndentifer("uuid:c3671020-15e0-11da-9b3b-f0439d4867bd");
        sequenceOffer.setIdentifier(identifier);
        createSequence.setSequenceOffer(sequenceOffer);
        SOAPEnvelope envelope = this.getEmptySOAPEnvelope();
        createSequence.toSOAPEnvelope(envelope);
        OMElement createSequencePart = envelope.getBody().getFirstChildWithName(new QName(this.rmNamespaceValue, "CreateSequence"));
        OMElement acksToPart = createSequencePart.getFirstChildWithName(new QName(this.rmNamespaceValue, "AcksTo"));
        OMElement addressPart = acksToPart.getFirstChildWithName(new QName(this.addressingNamespaceValue, "Address"));
        CreateSequenceTest.assertEquals((String)"http://127.0.0.1:9090/axis/services/RMService", (String)addressPart.getText());
        OMElement offerPart = createSequencePart.getFirstChildWithName(new QName(this.rmNamespaceValue, "Offer"));
        OMElement identifierPart = offerPart.getFirstChildWithName(new QName(this.rmNamespaceValue, "Identifier"));
        CreateSequenceTest.assertEquals((String)"uuid:c3671020-15e0-11da-9b3b-f0439d4867bd", (String)identifierPart.getText());
    }
}

