/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.Nack;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class SequenceAcknowledgementTest
extends SandeshaTestCase {
    SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
    String rmNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm";

    public SequenceAcknowledgementTest() {
        super("SequenceAcknowledgementTest");
    }

    public void testFromOMElement() throws SandeshaException {
        QName name = new QName(this.rmNamespace, "SequenceAcknowledgement");
        SequenceAcknowledgement sequenceAck = new SequenceAcknowledgement(this.rmNamespace);
        SOAPEnvelope env = this.getSOAPEnvelope("", "SequenceAcknowledgement.xml");
        sequenceAck.fromOMElement(env.getHeader().getFirstChildWithName(name));
        Identifier identifier = sequenceAck.getIdentifier();
        SequenceAcknowledgementTest.assertEquals((String)"uuid:897ee740-1624-11da-a28e-b3b9c4e71445", (String)identifier.getIdentifier());
        Iterator iterator = sequenceAck.getAcknowledgementRanges().iterator();
        while (iterator.hasNext()) {
            AcknowledgementRange ackRange = (AcknowledgementRange)iterator.next();
            if (ackRange.getLowerValue() == 1L) {
                SequenceAcknowledgementTest.assertEquals((long)2L, (long)ackRange.getUpperValue());
                continue;
            }
            if (ackRange.getLowerValue() == 4L) {
                SequenceAcknowledgementTest.assertEquals((long)6L, (long)ackRange.getUpperValue());
                continue;
            }
            if (ackRange.getLowerValue() != 8L) continue;
            SequenceAcknowledgementTest.assertEquals((long)10L, (long)ackRange.getUpperValue());
        }
        iterator = sequenceAck.getNackList().iterator();
        while (iterator.hasNext()) {
            Nack nack = (Nack)iterator.next();
            if (nack.getNackNumber() == 3L || nack.getNackNumber() == 7L) continue;
            SequenceAcknowledgementTest.fail((String)("invalid nack : " + nack.getNackNumber()));
        }
    }

    public void testToOMElement() throws SandeshaException {
        SequenceAcknowledgement seqAck = new SequenceAcknowledgement(this.rmNamespace);
        Identifier identifier = new Identifier(this.rmNamespace);
        identifier.setIndentifer("uuid:897ee740-1624-11da-a28e-b3b9c4e71445");
        seqAck.setIdentifier(identifier);
        SOAPEnvelope env = this.getEmptySOAPEnvelope();
        seqAck.toSOAPEnvelope(env);
        OMElement sequenceAckPart = env.getHeader().getFirstChildWithName(new QName(this.rmNamespace, "SequenceAcknowledgement"));
        OMElement identifierPart = sequenceAckPart.getFirstChildWithName(new QName(this.rmNamespace, "Identifier"));
        SequenceAcknowledgementTest.assertEquals((String)"uuid:897ee740-1624-11da-a28e-b3b9c4e71445", (String)identifierPart.getText());
    }
}

