/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MessageNumber;
import org.apache.sandesha2.wsrm.Sequence;

public class SequenceTest
extends SandeshaTestCase {
    SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
    String rmNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm";

    public SequenceTest() {
        super("SequenceTest");
    }

    public void testFromOMElement() throws SandeshaException {
        SOAPEnvelope env = this.getSOAPEnvelope("", "Sequence.xml");
        Sequence sequence = new Sequence(this.rmNamespace);
        sequence.fromOMElement((OMElement)env.getHeader());
        Identifier identifier = sequence.getIdentifier();
        SequenceTest.assertEquals((String)"uuid:879da420-1624-11da-bed9-84d13db13902", (String)identifier.getIdentifier());
        MessageNumber msgNo = sequence.getMessageNumber();
        SequenceTest.assertEquals((long)1L, (long)msgNo.getMessageNumber());
    }

    public void testToSOAPEnvelope() throws SandeshaException {
        Sequence sequence = new Sequence(this.rmNamespace);
        Identifier identifier = new Identifier(this.rmNamespace);
        identifier.setIndentifer("uuid:879da420-1624-11da-bed9-84d13db13902");
        sequence.setIdentifier(identifier);
        MessageNumber msgNo = new MessageNumber(this.rmNamespace);
        msgNo.setMessageNumber(1L);
        sequence.setMessageNumber(msgNo);
        SOAPEnvelope envelope = this.getEmptySOAPEnvelope();
        sequence.toSOAPEnvelope(envelope);
        OMElement sequencePart = envelope.getHeader().getFirstChildWithName(new QName(this.rmNamespace, "Sequence"));
        OMElement identifierPart = sequencePart.getFirstChildWithName(new QName(this.rmNamespace, "Identifier"));
        SequenceTest.assertEquals((String)"uuid:879da420-1624-11da-bed9-84d13db13902", (String)identifierPart.getText());
        OMElement msgNumberPart = sequencePart.getFirstChildWithName(new QName(this.rmNamespace, "MessageNumber"));
        SequenceTest.assertEquals((long)1L, (long)Long.parseLong(msgNumberPart.getText()));
    }
}

