/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class SandeshaClientAckRequestWaitTest
extends SandeshaTestCase {
    String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";

    public SandeshaClientAckRequestWaitTest() {
        super("SandeshaClientTest");
    }

    public void setUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAckRequestWithWait() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        clientOptions.setTo(new EndpointReference(to));
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        clientOptions.setAction(this.pingAction);
        String acksTo = serviceClient.getMyEPR("http").getAddress();
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        serviceClient.setOptions(clientOptions);
        try {
            SequenceReport report;
            serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
            SandeshaClient.sendAckRequest((ServiceClient)serviceClient);
            this.startServer(this.server_repoPath, this.server_axis2_xml);
            long limit = System.currentTimeMillis() + (long)this.waitTime;
            Error lastError = null;
            while (System.currentTimeMillis() < limit) {
                Thread.sleep(this.tickTime);
                try {
                    report = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                    SandeshaClientAckRequestWaitTest.assertEquals((byte)report.getSequenceStatus(), (byte)2);
                    lastError = null;
                    break;
                }
                catch (Error e) {
                    lastError = e;
                }
            }
            if (lastError != null) {
                throw lastError;
            }
            SandeshaClient.terminateSequence((ServiceClient)serviceClient);
            SandeshaClient.waitUntilSequenceCompleted((ServiceClient)serviceClient, (long)30000L);
            report = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
            SandeshaClientAckRequestWaitTest.assertNotNull((Object)report);
            SandeshaClientAckRequestWaitTest.assertEquals((byte)3, (byte)report.getSequenceStatus());
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }
}

