/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaReport;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.util.SandeshaUtil;

public class SandeshaReportsTest
extends SandeshaTestCase {
    private boolean startedServer = false;

    public SandeshaReportsTest() {
        super("SandeshaReportsTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        if (!this.startedServer) {
            this.startServer(repoPath, axis2_xml);
        }
        this.startedServer = true;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSequenceReports() throws Exception {
        SequenceReport sequenceReport;
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        String acksTo = serviceClient.getMyEPR("http").getAddress();
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        serviceClient.setOptions(clientOptions);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        serviceClient.setOptions(clientOptions);
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(SandeshaReportsTest.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        SandeshaTestCase.TestCallback callback2 = new SandeshaTestCase.TestCallback("Callback 2");
        serviceClient.sendReceiveNonBlocking(SandeshaReportsTest.getEchoOMBlock("echo2", sequenceKey), (AxisCallback)callback2);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SandeshaReportsTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(1L)));
                SandeshaReportsTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(2L)));
                SandeshaReportsTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)2);
                SandeshaReportsTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                List incomingSequenceReports = SandeshaClient.getIncomingSequenceReports((ConfigurationContext)configContext);
                SandeshaReportsTest.assertEquals((int)incomingSequenceReports.size(), (int)1);
                SequenceReport incomingSequenceReport = (SequenceReport)incomingSequenceReports.get(0);
                SandeshaReportsTest.assertEquals((int)incomingSequenceReport.getCompletedMessages().size(), (int)2);
                SandeshaReportsTest.assertNotNull((Object)incomingSequenceReport.getSequenceID());
                SandeshaReportsTest.assertEquals((byte)incomingSequenceReport.getSequenceDirection(), (byte)1);
                SandeshaReportsTest.assertNotNull((Object)incomingSequenceReport.getInternalSequenceID());
                SandeshaReportsTest.assertEquals((String)incomingSequenceReport.getSequenceID(), (String)incomingSequenceReport.getInternalSequenceID());
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        SandeshaClient.terminateSequence((ServiceClient)serviceClient, (String)sequenceKey);
        SandeshaClient.waitUntilSequenceCompleted((ServiceClient)serviceClient, (String)sequenceKey);
        sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
        SandeshaReportsTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)3);
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    public void testRMReport() throws AxisFault, InterruptedException {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey1 = "sequence3";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey1);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
        String sequenceKey2 = "sequence4";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey2);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"false");
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SandeshaReport rmReport = SandeshaClient.getSandeshaReport((ConfigurationContext)configContext);
                SequenceReport sequence1Report = null;
                SequenceReport sequence2Report = null;
                Iterator iterator = rmReport.getOutgoingSequenceList().iterator();
                while (iterator.hasNext()) {
                    String sequenceID = (String)iterator.next();
                    String internalSequenceID = rmReport.getInternalSequenceIdOfOutSequence(sequenceID);
                    if (internalSequenceID.indexOf(sequenceKey1) >= 0) {
                        sequence1Report = SandeshaClient.getOutgoingSequenceReport((String)to, (String)sequenceKey1, (ConfigurationContext)configContext);
                        continue;
                    }
                    if (internalSequenceID.indexOf(sequenceKey2) < 0) continue;
                    sequence2Report = SandeshaClient.getOutgoingSequenceReport((String)to, (String)sequenceKey2, (ConfigurationContext)configContext);
                }
                SandeshaReportsTest.assertNotNull(sequence1Report);
                SandeshaReportsTest.assertNotNull(sequence2Report);
                SandeshaReportsTest.assertEquals((int)sequence1Report.getCompletedMessages().size(), (int)2);
                SandeshaReportsTest.assertEquals((int)sequence2Report.getCompletedMessages().size(), (int)1);
                SandeshaReportsTest.assertEquals((byte)sequence1Report.getSequenceStatus(), (byte)3);
                SandeshaReportsTest.assertEquals((byte)sequence2Report.getSequenceStatus(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

