/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.faulttests;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.util.SandeshaUtil;

public class CreateSequenceRefusedInboundFaultTest
extends SandeshaTestCase {
    private boolean startedServer = false;

    public CreateSequenceRefusedInboundFaultTest() {
        super("CreateSequenceRefusedInboundFaultTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        if (!this.startedServer) {
            this.startServer(repoPath, axis2_xml);
            this.startedServer = true;
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSOAP11CreateSequenceRefusedInboundFault() throws Exception {
        this.runTest(false);
    }

    public void testSOAP12CreateSequenceRefusedInboundFault() throws Exception {
        this.runTest(true);
    }

    private void runTest(boolean runSoap12) throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        if (runSoap12) {
            clientOptions.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        }
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        String acksTo = "http://www.w3.org/2005/08/addressing/none";
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        serviceClient.setOptions(clientOptions);
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(CreateSequenceRefusedInboundFaultTest.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                CreateSequenceRefusedInboundFaultTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)3);
                CreateSequenceRefusedInboundFaultTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                CreateSequenceRefusedInboundFaultTest.assertTrue((boolean)callback1.isErrorReported());
                CreateSequenceRefusedInboundFaultTest.assertEquals((String)callback1.getResult(), null);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

