/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.versions;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class AddressingVersionTest
extends SandeshaTestCase {
    private boolean serverStarted = false;

    public AddressingVersionTest() {
        super("AddressingVersionTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        if (!this.serverStarted) {
            this.startServer(repoPath, axis2_xml);
        }
        this.serverStarted = true;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddressingFinal() throws Exception {
        Options clientOptions = new Options();
        clientOptions.setProperty("WSAddressingVersion", (Object)"http://www.w3.org/2005/08/addressing");
        this.runAddressingTest(clientOptions);
    }

    public void testAddressingSubmission() throws Exception {
        Options clientOptions = new Options();
        clientOptions.setProperty("WSAddressingVersion", (Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
        this.runAddressingTest(clientOptions);
    }

    public void testAddressingDefault() throws Exception {
        Options clientOptions = new Options();
        this.runAddressingTest(clientOptions);
    }

    public void testAddressingNone() throws Exception {
        Options clientOptions = new Options();
        clientOptions.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        this.runAddressingTest(clientOptions);
    }

    private void runAddressingTest(Options clientOptions) throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = "sequence1";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getPingOMBlock("ping"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                AddressingVersionTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(1L)));
                AddressingVersionTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)3);
                AddressingVersionTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

