/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.io.File;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisDescription;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;

public class ForceInboundDispatchTest
extends SandeshaTestCase {
    private static ConfigurationContext serverConfigCtx = null;
    private boolean startedServer = false;

    public ForceInboundDispatchTest() {
        super("ForceDispatchTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        if (!this.startedServer) {
            serverConfigCtx = this.startServer(repoPath, axis2_xml);
        }
        this.startedServer = true;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForceInvoke() throws AxisFault, InterruptedException {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = "sequence1";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        try {
            serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
            clientOptions.setProperty(SandeshaClientConstants.MESSAGE_NUMBER, (Object)new Long(3L));
            serviceClient.fireAndForget(this.getPingOMBlock("ping3"));
            Thread.sleep(5000L);
            StorageManager mgr = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)configContext);
            Transaction t = mgr.getTransaction();
            String inboundSequenceID = SandeshaUtil.getSequenceIDFromInternalSequenceID((String)SandeshaUtil.getInternalSequenceID((String)to, (String)sequenceKey), (StorageManager)mgr);
            t.commit();
            SandeshaClient.forceDispatchOfInboundMessages((ConfigurationContext)serverConfigCtx, (String)inboundSequenceID, (boolean)true);
            StorageManager serverStore = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)serverConfigCtx);
            t = serverStore.getTransaction();
            RMDBean rMDBean = serverStore.getRMDBeanMgr().retrieve(inboundSequenceID);
            ForceInboundDispatchTest.assertNotNull((Object)rMDBean);
            ForceInboundDispatchTest.assertEquals((long)rMDBean.getNextMsgNoToProcess(), (long)4L);
            ForceInboundDispatchTest.assertNotNull((Object)rMDBean.getOutOfOrderRanges());
            RangeString rangeString = rMDBean.getOutOfOrderRanges();
            ForceInboundDispatchTest.assertTrue((boolean)rangeString.isMessageNumberInRanges(2L));
            t.commit();
            String internalSequenceId = SandeshaUtil.getInternalSequenceID((String)to, (String)sequenceKey);
            t = mgr.getTransaction();
            RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId((StorageManager)mgr, (String)internalSequenceId);
            rmsBean.setNextMessageNumber(1L);
            mgr.getRMSBeanMgr().update(rmsBean);
            t.commit();
            clientOptions.setProperty(SandeshaClientConstants.MESSAGE_NUMBER, (Object)new Long(2L));
            serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForceInvokeWithDiscardGaps() throws AxisFault {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = "sequence2";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        try {
            serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
            clientOptions.setProperty(SandeshaClientConstants.MESSAGE_NUMBER, (Object)new Long(3L));
            serviceClient.fireAndForget(this.getPingOMBlock("ping3"));
            String internalSequenceId = SandeshaUtil.getInternalSequenceID((String)to, (String)sequenceKey);
            this.waitForMessageToBeAcked(serviceClient, internalSequenceId);
            StorageManager mgr = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)configContext);
            Transaction t = mgr.getTransaction();
            String inboundSequenceID = SandeshaUtil.getSequenceIDFromInternalSequenceID((String)internalSequenceId, (StorageManager)mgr);
            t.commit();
            SandeshaClient.forceDispatchOfInboundMessages((ConfigurationContext)serverConfigCtx, (String)inboundSequenceID, (boolean)false);
            StorageManager serverMgr = SandeshaUtil.getInMemoryStorageManager((ConfigurationContext)serverConfigCtx);
            t = serverMgr.getTransaction();
            RMDBean rMDBean = serverMgr.getRMDBeanMgr().retrieve(inboundSequenceID);
            ForceInboundDispatchTest.assertNotNull((Object)rMDBean);
            ForceInboundDispatchTest.assertEquals((long)rMDBean.getNextMsgNoToProcess(), (long)4L);
            t.commit();
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }

    private void waitForMessageToBeAcked(ServiceClient serviceClient, String internalSequenceId) throws SandeshaException {
        ConfigurationContext context = serviceClient.getServiceContext().getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)context, (AxisDescription)context.getAxisConfiguration());
        Transaction transaction = storageManager.getTransaction();
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId((StorageManager)storageManager, (String)internalSequenceId);
        transaction.commit();
        long highestOutMsgNum = rmsBean.getHighestOutMessageNumber();
        Long highestOutMsgKey = new Long(highestOutMsgNum);
        long timeNow = System.currentTimeMillis();
        long timeToComplete = timeNow + (long)this.waitTime;
        boolean complete = false;
        while (!complete && timeNow < timeToComplete) {
            timeNow = System.currentTimeMillis();
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                if (sequenceReport.getCompletedMessages().contains(highestOutMsgKey)) {
                    complete = true;
                    continue;
                }
                Thread.sleep(this.tickTime);
            }
            catch (Exception e) {}
        }
    }
}

