/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.wsrm.Accept;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.Identifier;

public class CreateSequenceResponseTest
extends SandeshaTestCase {
    SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
    String rmNamespaceValue = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    String addressingNamespaceValue = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    public CreateSequenceResponseTest() {
        super("CreateSequenceResponseTest");
    }

    public void testFromOMElement() throws AxisFault {
        CreateSequenceResponse res = new CreateSequenceResponse(this.rmNamespaceValue);
        SOAPEnvelope env = this.getSOAPEnvelope("", "CreateSequenceResponse.xml");
        res.fromOMElement((OMElement)env.getBody());
        Identifier identifier = res.getIdentifier();
        CreateSequenceResponseTest.assertEquals((String)"uuid:88754b00-161a-11da-b6d6-8198de3c47c5", (String)identifier.getIdentifier());
        Accept accept = res.getAccept();
        AcksTo acksTo = accept.getAcksTo();
        CreateSequenceResponseTest.assertEquals((String)"http://localhost:8070/axis/services/TestService", (String)acksTo.getEPR().getAddress());
    }

    public void testToSOAPEnvelope() throws AxisFault {
        CreateSequenceResponse res = new CreateSequenceResponse(this.rmNamespaceValue);
        Identifier identifier = new Identifier(this.rmNamespaceValue);
        identifier.setIndentifer("uuid:88754b00-161a-11da-b6d6-8198de3c47c5");
        res.setIdentifier(identifier);
        EndpointReference epr = new EndpointReference("http://localhost:8070/axis/services/TestService");
        Accept accept = new Accept(this.rmNamespaceValue);
        AcksTo acksTo = new AcksTo(epr, this.rmNamespaceValue, this.addressingNamespaceValue);
        accept.setAcksTo(acksTo);
        res.setAccept(accept);
        SOAPEnvelope env = this.getEmptySOAPEnvelope();
        res.toSOAPEnvelope(env);
        OMElement createSeqResponsePart = env.getBody().getFirstChildWithName(new QName(this.rmNamespaceValue, "CreateSequenceResponse"));
        OMElement identifierPart = createSeqResponsePart.getFirstChildWithName(new QName(this.rmNamespaceValue, "Identifier"));
        CreateSequenceResponseTest.assertEquals((String)"uuid:88754b00-161a-11da-b6d6-8198de3c47c5", (String)identifierPart.getText());
        OMElement acceptPart = createSeqResponsePart.getFirstChildWithName(new QName(this.rmNamespaceValue, "Accept"));
        OMElement acksToPart = acceptPart.getFirstChildWithName(new QName(this.rmNamespaceValue, "AcksTo"));
        OMElement addressPart = acksToPart.getFirstChildWithName(new QName(this.addressingNamespaceValue, "Address"));
        CreateSequenceResponseTest.assertEquals((String)"http://localhost:8070/axis/services/TestService", (String)addressPart.getText());
    }
}

