/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.wsrm.Address;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MakeConnection;

public class MakeConnectionTest
extends SandeshaTestCase {
    SOAPFactory factory = OMAbstractFactory.getSOAP11Factory();
    String rmNamespaceValue = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    String mcNamespaceValue = "http://docs.oasis-open.org/ws-rx/wsmc/200702";
    String addressingNamespaceValue = "http://www.w3.org/2005/08/addressing";

    public MakeConnectionTest() {
        super("MakeConnectionTest");
    }

    public void testfromOMElement() throws AxisFault {
        MakeConnection makeConnection = new MakeConnection(this.mcNamespaceValue);
        SOAPEnvelope envelope = this.getSOAPEnvelope("", "MakeConnection.xml");
        OMElement makeConnectionElement = envelope.getBody().getFirstChildWithName(new QName(this.mcNamespaceValue, "MakeConnection"));
        makeConnection.fromOMElement(makeConnectionElement);
        Identifier identifier = makeConnection.getIdentifier();
        MakeConnectionTest.assertNotNull((Object)identifier);
        MakeConnectionTest.assertEquals((String)identifier.getIdentifier(), (String)"urn:uuid:6367739C8350488CD411576188379313");
        Address address = makeConnection.getAddress();
        MakeConnectionTest.assertNotNull((Object)address);
        MakeConnectionTest.assertEquals((String)address.getAddress(), (String)"http://docs.oasis-open.org/wsrx/wsrm/200702/anonymous?id=550e8400-e29b-11d4-a716-446655440000");
    }

    public void testToSOAPEnvelope() throws SandeshaException {
        MakeConnection makeConnection = new MakeConnection(this.mcNamespaceValue);
        Address address = new Address(this.mcNamespaceValue);
        address.setAddress("http://docs.oasis-open.org/wsrx/wsrm/200702/anonymous?id=550e8400-e29b-11d4-a716-446655440000");
        Identifier identifier = new Identifier(this.rmNamespaceValue);
        identifier.setIndentifer("uuid:c3671020-15e0-11da-9b3b-f0439d4867bd");
        makeConnection.setAddress(address);
        makeConnection.setIdentifier(identifier);
        SOAPEnvelope envelope = this.getEmptySOAPEnvelope();
        makeConnection.toSOAPEnvelope(envelope);
        OMElement makeConnectionElement = envelope.getBody().getFirstChildWithName(new QName(this.mcNamespaceValue, "MakeConnection"));
        MakeConnectionTest.assertNotNull((Object)makeConnectionElement);
        OMElement addressElement = makeConnectionElement.getFirstChildWithName(new QName(this.mcNamespaceValue, "Address"));
        MakeConnectionTest.assertNotNull((Object)addressElement);
        String addressValue = addressElement.getText();
        MakeConnectionTest.assertEquals((String)addressValue, (String)"http://docs.oasis-open.org/wsrx/wsrm/200702/anonymous?id=550e8400-e29b-11d4-a716-446655440000");
        OMElement identifierElement = makeConnectionElement.getFirstChildWithName(new QName(this.rmNamespaceValue, "Identifier"));
        MakeConnectionTest.assertNotNull((Object)identifierElement);
        String identifierValue = identifierElement.getText();
        MakeConnectionTest.assertEquals((String)identifierValue, (String)"uuid:c3671020-15e0-11da-9b3b-f0439d4867bd");
    }
}

