/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class MessageRetransmissionTest
extends SandeshaTestCase {
    private static final String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    private static final String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";

    public MessageRetransmissionTest() {
        super("MessageRetransmissionTest");
    }

    public void testMessageRetransmission() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = "sequence1";
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        Thread.sleep(3000L);
        this.startServer(server_repoPath, server_axis2_xml);
        serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                MessageRetransmissionTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(1L)));
                MessageRetransmissionTest.assertTrue((boolean)sequenceReport.getCompletedMessages().contains(new Long(2L)));
                MessageRetransmissionTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

