/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class SandeshaClientTerminateWaitTest
extends SandeshaTestCase {
    String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";

    public SandeshaClientTerminateWaitTest() {
        super("SandeshaClientTest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTerminateSequenceWithWait() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)"Spec_2007_02");
        clientOptions.setTo(new EndpointReference(to));
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        String acksTo = serviceClient.getMyEPR("http").getAddress();
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        serviceClient.setOptions(clientOptions);
        try {
            serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
            SandeshaClient.terminateSequence((ServiceClient)serviceClient);
            try {
                serviceClient.fireAndForget(this.getPingOMBlock("ping2"));
                SandeshaClientTerminateWaitTest.fail();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.startServer(this.server_repoPath, this.server_axis2_xml);
            SandeshaClient.waitUntilSequenceCompleted((ServiceClient)serviceClient, (long)30000L);
            SequenceReport report = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
            SandeshaClientTerminateWaitTest.assertNotNull((Object)report);
            SandeshaClientTerminateWaitTest.assertEquals((byte)3, (byte)report.getSequenceStatus());
        }
        finally {
            configContext.getListenerManager().stop();
            serviceClient.cleanup();
        }
    }
}

