/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.faulttests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.faulttests.FaultTestUtils;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.CreateSequence;

public class CreateSequenceRefusedFaultTest
extends SandeshaTestCase {
    private static final String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    private static final String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
    private static ConfigurationContext serverConfigContext;

    public CreateSequenceRefusedFaultTest() {
        super("CreateSequenceProcessorTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        serverConfigContext = this.startServer(server_repoPath, server_axis2_xml);
    }

    public void testCreateSequenceSOAPFault() throws Exception {
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequence");
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getMessageAsBytes();
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        CreateSequenceRefusedFaultTest.assertNotNull((Object)message);
        CreateSequenceRefusedFaultTest.assertTrue((message.indexOf("CreateSequenceRefused") > -1 ? 1 : 0) != 0);
        connection.disconnect();
    }

    private byte[] getMessageAsBytes() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        SOAP11Factory factory = new SOAP11Factory();
        SOAPEnvelope dummyEnvelope = factory.getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(serverConfigContext);
        messageContext.setAxisService(serverConfigContext.getAxisConfiguration().getService("RMSampleService"));
        messageContext.setEnvelope(dummyEnvelope);
        RMMsgContext applicationRMMsg = new RMMsgContext(messageContext);
        RMSBean rmsBean = new RMSBean();
        rmsBean.setRMVersion("Spec_2007_02");
        rmsBean.setToEPR(to);
        rmsBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/none");
        RMMsgContext createSeqRMMessage = RMMsgCreator.createCreateSeqMsg((RMSBean)rmsBean, (RMMsgContext)applicationRMMsg);
        messageContext = createSeqRMMessage.getMessageContext();
        messageContext.setWSAAction(SpecSpecificConstants.getCreateSequenceAction((String)"Spec_2007_02"));
        CreateSequence createSeqResPart = (CreateSequence)createSeqRMMessage.getMessagePart(9);
        createSeqResPart.setAcksTo(new AcksTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"), SpecSpecificConstants.getRMNamespaceValue((String)rmsBean.getRMVersion()), "http://www.w3.org/2005/08/addressing"));
        createSeqRMMessage.addSOAPEnvelope();
        SOAPEnvelope envelope = createSeqRMMessage.getMessageContext().getEnvelope();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        envelope.serialize((OutputStream)outputStream);
        return outputStream.toByteArray();
    }
}

