/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.faulttests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.faulttests.FaultTestUtils;
import org.apache.sandesha2.msgreceivers.RMMessageReceiver;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MessageNumber;
import org.apache.sandesha2.wsrm.Sequence;

public class SequenceClosedFaultTest
extends SandeshaTestCase {
    private static final String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    private static final String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
    private ConfigurationContext serverConfigContext;

    public SequenceClosedFaultTest() {
        super("SequenceClosedFaultTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.serverConfigContext = this.startServer(server_repoPath, server_axis2_xml);
    }

    public void testSequenceClosedFault() throws Exception {
        HttpURLConnection connection = FaultTestUtils.getHttpURLConnection("http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService", this.pingAction);
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)this.serverConfigContext, (AxisDescription)this.serverConfigContext.getAxisConfiguration());
        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
        String seqID = SandeshaUtil.getUUID();
        RMDBean rmdBean = new RMDBean();
        rmdBean.setSequenceID(seqID);
        rmdBean.setToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setAcksToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setReplyToEPR("http://www.w3.org/2005/08/addressing/anonymous");
        rmdBean.setRMVersion("Spec_2007_02");
        rmdBean.setServerCompletedMessages(new RangeString());
        rmdBean.setClosed(true);
        Transaction tran = storageManager.getTransaction();
        rmdBeanMgr.insert(rmdBean);
        tran.commit();
        OutputStream tmpOut2 = connection.getOutputStream();
        byte[] ar = this.getAppMessageAsBytes(seqID);
        tmpOut2.write(ar);
        tmpOut2.flush();
        String message = FaultTestUtils.retrieveResponseMessage(connection);
        SequenceClosedFaultTest.assertNotNull((Object)message);
        SequenceClosedFaultTest.assertTrue((message.indexOf("wsrm:SequenceClosed") > -1 ? 1 : 0) != 0);
        String faultID = message.substring(message.indexOf("<wsrm:Identifier>") + 17, message.indexOf("</wsrm:Identifier>"));
        SequenceClosedFaultTest.assertEquals((String)seqID, (String)faultID);
        connection.disconnect();
    }

    private byte[] getAppMessageAsBytes(String uuid) throws Exception {
        SOAP11Factory factory = new SOAP11Factory();
        SOAPEnvelope dummyEnvelope = factory.getDefaultEnvelope();
        MessageContext messageContext = new MessageContext();
        messageContext.setConfigurationContext(this.serverConfigContext);
        messageContext.setAxisService(this.serverConfigContext.getAxisConfiguration().getService("RMSampleService"));
        messageContext.setEnvelope(dummyEnvelope);
        RMMsgContext applicationRMMsg = new RMMsgContext(messageContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue((String)"Spec_2007_02");
        Sequence sequence = new Sequence(rmNamespaceValue);
        MessageNumber msgNumber = new MessageNumber(rmNamespaceValue);
        msgNumber.setMessageNumber(1L);
        sequence.setMessageNumber(msgNumber);
        Identifier id1 = new Identifier(rmNamespaceValue);
        id1.setIndentifer(uuid);
        sequence.setIdentifier(id1);
        applicationRMMsg.setMessagePart(6, (IOMRMPart)sequence);
        applicationRMMsg.addSOAPEnvelope();
        messageContext.setWSAAction(this.pingAction);
        AxisOperation operation = messageContext.getAxisService().getOperation(Sandesha2Constants.RM_IN_OUT_OPERATION);
        operation.setMessageReceiver((MessageReceiver)new RMMessageReceiver());
        messageContext.setAxisOperation(operation);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        applicationRMMsg.getMessageContext().getEnvelope().serialize((OutputStream)outputStream);
        return outputStream.toByteArray();
    }
}

